/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kinesis.model.Tag;
import software.amazon.awssdk.services.kinesis.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForStreamResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTagsForStreamResponse> {
    private final List<Tag> tags;
    private final Boolean hasMoreTags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        this.tags = builder.tags;
        this.hasMoreTags = builder.hasMoreTags;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean hasMoreTags() {
        return this.hasMoreTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreTags() == null ? 0 : this.hasMoreTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse)((Object)obj);
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.hasMoreTags() == null ^ this.hasMoreTags() == null) {
            return false;
        }
        return other.hasMoreTags() == null || other.hasMoreTags().equals(this.hasMoreTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.hasMoreTags() != null) {
            sb.append("HasMoreTags: ").append(this.hasMoreTags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Tag> tags = new SdkInternalList();
        private Boolean hasMoreTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            this.setTags(model.tags);
            this.setHasMoreTags(model.hasMoreTags);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final Boolean getHasMoreTags() {
            return this.hasMoreTags;
        }

        @Override
        public final Builder hasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
            return this;
        }

        public final void setHasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
        }

        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForStreamResponse> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder hasMoreTags(Boolean var1);
    }
}

