/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig;

@SdkInternalApi
public class KMSEncryptionConfigMarshaller {
    private static final MarshallingInfo<String> AWSKMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSKMSKeyARN").build();
    private static final KMSEncryptionConfigMarshaller instance = new KMSEncryptionConfigMarshaller();

    public static KMSEncryptionConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(KMSEncryptionConfig kmsEncryptionConfig, ProtocolMarshaller protocolMarshaller) {
        if (kmsEncryptionConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kmsEncryptionConfig.awskmsKeyARN(), AWSKMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

