/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions;
import software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDestinationConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDestinationConfiguration> {
    private final String roleARN;
    private final String clusterJDBCURL;
    private final CopyCommand copyCommand;
    private final String username;
    private final String password;
    private final RedshiftRetryOptions retryOptions;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3BackupConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.password = builder.password;
        this.retryOptions = builder.retryOptions;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupConfiguration = builder.s3BackupConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clusterJDBCURL() {
        return this.clusterJDBCURL;
    }

    public CopyCommand copyCommand() {
        return this.copyCommand;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public RedshiftRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public String s3BackupMode() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3BackupConfiguration() {
        return this.s3BackupConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.clusterJDBCURL() == null ? 0 : this.clusterJDBCURL().hashCode());
        hashCode = 31 * hashCode + (this.copyCommand() == null ? 0 : this.copyCommand().hashCode());
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.password() == null ? 0 : this.password().hashCode());
        hashCode = 31 * hashCode + (this.retryOptions() == null ? 0 : this.retryOptions().hashCode());
        hashCode = 31 * hashCode + (this.s3Configuration() == null ? 0 : this.s3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.processingConfiguration() == null ? 0 : this.processingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupMode() == null ? 0 : this.s3BackupMode().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupConfiguration() == null ? 0 : this.s3BackupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationConfiguration)) {
            return false;
        }
        RedshiftDestinationConfiguration other = (RedshiftDestinationConfiguration)obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clusterJDBCURL() == null ^ this.clusterJDBCURL() == null) {
            return false;
        }
        if (other.clusterJDBCURL() != null && !other.clusterJDBCURL().equals(this.clusterJDBCURL())) {
            return false;
        }
        if (other.copyCommand() == null ^ this.copyCommand() == null) {
            return false;
        }
        if (other.copyCommand() != null && !other.copyCommand().equals(this.copyCommand())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3Configuration() == null ^ this.s3Configuration() == null) {
            return false;
        }
        if (other.s3Configuration() != null && !other.s3Configuration().equals(this.s3Configuration())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.s3BackupMode() == null ^ this.s3BackupMode() == null) {
            return false;
        }
        if (other.s3BackupMode() != null && !other.s3BackupMode().equals(this.s3BackupMode())) {
            return false;
        }
        if (other.s3BackupConfiguration() == null ^ this.s3BackupConfiguration() == null) {
            return false;
        }
        if (other.s3BackupConfiguration() != null && !other.s3BackupConfiguration().equals(this.s3BackupConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptions() == null || other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.clusterJDBCURL() != null) {
            sb.append("ClusterJDBCURL: ").append(this.clusterJDBCURL()).append(",");
        }
        if (this.copyCommand() != null) {
            sb.append("CopyCommand: ").append(this.copyCommand()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        if (this.retryOptions() != null) {
            sb.append("RetryOptions: ").append(this.retryOptions()).append(",");
        }
        if (this.s3Configuration() != null) {
            sb.append("S3Configuration: ").append(this.s3Configuration()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.s3BackupMode() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupMode()).append(",");
        }
        if (this.s3BackupConfiguration() != null) {
            sb.append("S3BackupConfiguration: ").append(this.s3BackupConfiguration()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String clusterJDBCURL;
        private CopyCommand copyCommand;
        private String username;
        private String password;
        private RedshiftRetryOptions retryOptions;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationConfiguration s3BackupConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationConfiguration model) {
            this.setRoleARN(model.roleARN);
            this.setClusterJDBCURL(model.clusterJDBCURL);
            this.setCopyCommand(model.copyCommand);
            this.setUsername(model.username);
            this.setPassword(model.password);
            this.setRetryOptions(model.retryOptions);
            this.setS3Configuration(model.s3Configuration);
            this.setProcessingConfiguration(model.processingConfiguration);
            this.setS3BackupMode(model.s3BackupMode);
            this.setS3BackupConfiguration(model.s3BackupConfiguration);
            this.setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return this.clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand getCopyCommand() {
            return this.copyCommand;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final RedshiftRetryOptions getRetryOptions() {
            return this.retryOptions;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
        }

        public final S3DestinationConfiguration getS3Configuration() {
            return this.s3Configuration;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return this.processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final void setS3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
        }

        public final S3DestinationConfiguration getS3BackupConfiguration() {
            return this.s3BackupConfiguration;
        }

        @Override
        public final Builder s3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
            return this;
        }

        public final void setS3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        public RedshiftDestinationConfiguration build() {
            return new RedshiftDestinationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder clusterJDBCURL(String var1);

        public Builder copyCommand(CopyCommand var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder retryOptions(RedshiftRetryOptions var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        public Builder processingConfiguration(ProcessingConfiguration var1);

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(RedshiftS3BackupMode var1);

        public Builder s3BackupConfiguration(S3DestinationConfiguration var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);
    }
}

