/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellValue;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesKeysMapCopier;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesRow;
import software.amazon.awssdk.services.keyspacesstreams.model.OriginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> EVENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventVersion").getter(Record.getter(Record::eventVersion)).setter(Record.setter(Builder::eventVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Record.getter(Record::createdAt)).setter(Record.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("origin").getter(Record.getter(Record::originAsString)).setter(Record.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<Map<String, KeyspacesCellValue>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("partitionKeys").getter(Record.getter(Record::partitionKeys)).setter(Record.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCellValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, KeyspacesCellValue>> CLUSTERING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("clusteringKeys").getter(Record.getter(Record::clusteringKeys)).setter(Record.setter(Builder::clusteringKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusteringKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCellValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KeyspacesRow> NEW_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newImage").getter(Record.getter(Record::newImage)).setter(Record.setter(Builder::newImage)).constructor(KeyspacesRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImage").build()}).build();
    private static final SdkField<KeyspacesRow> OLD_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oldImage").getter(Record.getter(Record::oldImage)).setter(Record.setter(Builder::oldImage)).constructor(KeyspacesRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oldImage").build()}).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceNumber").getter(Record.getter(Record::sequenceNumber)).setter(Record.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VERSION_FIELD, CREATED_AT_FIELD, ORIGIN_FIELD, PARTITION_KEYS_FIELD, CLUSTERING_KEYS_FIELD, NEW_IMAGE_FIELD, OLD_IMAGE_FIELD, SEQUENCE_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Record.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventVersion;
    private final Instant createdAt;
    private final String origin;
    private final Map<String, KeyspacesCellValue> partitionKeys;
    private final Map<String, KeyspacesCellValue> clusteringKeys;
    private final KeyspacesRow newImage;
    private final KeyspacesRow oldImage;
    private final String sequenceNumber;

    private Record(BuilderImpl builder) {
        this.eventVersion = builder.eventVersion;
        this.createdAt = builder.createdAt;
        this.origin = builder.origin;
        this.partitionKeys = builder.partitionKeys;
        this.clusteringKeys = builder.clusteringKeys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public final String eventVersion() {
        return this.eventVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final OriginType origin() {
        return OriginType.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeyspacesCellValue> partitionKeys() {
        return this.partitionKeys;
    }

    public final boolean hasClusteringKeys() {
        return this.clusteringKeys != null && !(this.clusteringKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeyspacesCellValue> clusteringKeys() {
        return this.clusteringKeys;
    }

    public final KeyspacesRow newImage() {
        return this.newImage;
    }

    public final KeyspacesRow oldImage() {
        return this.oldImage;
    }

    public final String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusteringKeys() ? this.clusteringKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.eventVersion(), other.eventVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.originAsString(), other.originAsString()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && this.hasClusteringKeys() == other.hasClusteringKeys() && Objects.equals(this.clusteringKeys(), other.clusteringKeys()) && Objects.equals(this.newImage(), other.newImage()) && Objects.equals(this.oldImage(), other.oldImage()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("EventVersion", (Object)this.eventVersion()).add("CreatedAt", (Object)this.createdAt()).add("Origin", (Object)this.originAsString()).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("ClusteringKeys", this.hasClusteringKeys() ? this.clusteringKeys() : null).add("NewImage", (Object)this.newImage()).add("OldImage", (Object)this.oldImage()).add("SequenceNumber", (Object)this.sequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventVersion": {
                return Optional.ofNullable(clazz.cast(this.eventVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "partitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "clusteringKeys": {
                return Optional.ofNullable(clazz.cast(this.clusteringKeys()));
            }
            case "newImage": {
                return Optional.ofNullable(clazz.cast(this.newImage()));
            }
            case "oldImage": {
                return Optional.ofNullable(clazz.cast(this.oldImage()));
            }
            case "sequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventVersion", EVENT_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("origin", ORIGIN_FIELD);
        map.put("partitionKeys", PARTITION_KEYS_FIELD);
        map.put("clusteringKeys", CLUSTERING_KEYS_FIELD);
        map.put("newImage", NEW_IMAGE_FIELD);
        map.put("oldImage", OLD_IMAGE_FIELD);
        map.put("sequenceNumber", SEQUENCE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventVersion;
        private Instant createdAt;
        private String origin;
        private Map<String, KeyspacesCellValue> partitionKeys = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, KeyspacesCellValue> clusteringKeys = DefaultSdkAutoConstructMap.getInstance();
        private KeyspacesRow newImage;
        private KeyspacesRow oldImage;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.eventVersion(model.eventVersion);
            this.createdAt(model.createdAt);
            this.origin(model.origin);
            this.partitionKeys(model.partitionKeys);
            this.clusteringKeys(model.clusteringKeys);
            this.newImage(model.newImage);
            this.oldImage(model.oldImage);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getEventVersion() {
            return this.eventVersion;
        }

        public final void setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
        }

        @Override
        public final Builder eventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final Map<String, KeyspacesCellValue.Builder> getPartitionKeys() {
            Map<String, KeyspacesCellValue.Builder> result = KeyspacesKeysMapCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Map<String, KeyspacesCellValue.BuilderImpl> partitionKeys) {
            this.partitionKeys = KeyspacesKeysMapCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Map<String, KeyspacesCellValue> partitionKeys) {
            this.partitionKeys = KeyspacesKeysMapCopier.copy(partitionKeys);
            return this;
        }

        public final Map<String, KeyspacesCellValue.Builder> getClusteringKeys() {
            Map<String, KeyspacesCellValue.Builder> result = KeyspacesKeysMapCopier.copyToBuilder(this.clusteringKeys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setClusteringKeys(Map<String, KeyspacesCellValue.BuilderImpl> clusteringKeys) {
            this.clusteringKeys = KeyspacesKeysMapCopier.copyFromBuilder(clusteringKeys);
        }

        @Override
        public final Builder clusteringKeys(Map<String, KeyspacesCellValue> clusteringKeys) {
            this.clusteringKeys = KeyspacesKeysMapCopier.copy(clusteringKeys);
            return this;
        }

        public final KeyspacesRow.Builder getNewImage() {
            return this.newImage != null ? this.newImage.toBuilder() : null;
        }

        public final void setNewImage(KeyspacesRow.BuilderImpl newImage) {
            this.newImage = newImage != null ? newImage.build() : null;
        }

        @Override
        public final Builder newImage(KeyspacesRow newImage) {
            this.newImage = newImage;
            return this;
        }

        public final KeyspacesRow.Builder getOldImage() {
            return this.oldImage != null ? this.oldImage.toBuilder() : null;
        }

        public final void setOldImage(KeyspacesRow.BuilderImpl oldImage) {
            this.oldImage = oldImage != null ? oldImage.build() : null;
        }

        @Override
        public final Builder oldImage(KeyspacesRow oldImage) {
            this.oldImage = oldImage;
            return this;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder eventVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder partitionKeys(Map<String, KeyspacesCellValue> var1);

        public Builder clusteringKeys(Map<String, KeyspacesCellValue> var1);

        public Builder newImage(KeyspacesRow var1);

        default public Builder newImage(Consumer<KeyspacesRow.Builder> newImage) {
            return this.newImage((KeyspacesRow)((KeyspacesRow.Builder)KeyspacesRow.builder().applyMutation(newImage)).build());
        }

        public Builder oldImage(KeyspacesRow var1);

        default public Builder oldImage(Consumer<KeyspacesRow.Builder> oldImage) {
            return this.oldImage((KeyspacesRow)((KeyspacesRow.Builder)KeyspacesRow.builder().applyMutation(oldImage)).build());
        }

        public Builder sequenceNumber(String var1);
    }
}

