/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata information associated with Amazon Keyspaces cells and rows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyspacesMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyspacesMetadata.Builder, KeyspacesMetadata> {
    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expirationTime").getter(getter(KeyspacesMetadata::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()).build();

    private static final SdkField<String> WRITE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("writeTime").getter(getter(KeyspacesMetadata::writeTime)).setter(setter(Builder::writeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_TIME_FIELD,
            WRITE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expirationTime;

    private final String writeTime;

    private KeyspacesMetadata(BuilderImpl builder) {
        this.expirationTime = builder.expirationTime;
        this.writeTime = builder.writeTime;
    }

    /**
     * <p>
     * The time at which the associated data will expire, based on the time-to-live (TTL) setting.
     * </p>
     * 
     * @return The time at which the associated data will expire, based on the time-to-live (TTL) setting.
     */
    public final String expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The timestamp at which the associated data was written to the database.
     * </p>
     * 
     * @return The timestamp at which the associated data was written to the database.
     */
    public final String writeTime() {
        return writeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(writeTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesMetadata)) {
            return false;
        }
        KeyspacesMetadata other = (KeyspacesMetadata) obj;
        return Objects.equals(expirationTime(), other.expirationTime()) && Objects.equals(writeTime(), other.writeTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyspacesMetadata").add("ExpirationTime", expirationTime()).add("WriteTime", writeTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "writeTime":
            return Optional.ofNullable(clazz.cast(writeTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("writeTime", WRITE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesMetadata, T> g) {
        return obj -> g.apply((KeyspacesMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyspacesMetadata> {
        /**
         * <p>
         * The time at which the associated data will expire, based on the time-to-live (TTL) setting.
         * </p>
         * 
         * @param expirationTime
         *        The time at which the associated data will expire, based on the time-to-live (TTL) setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(String expirationTime);

        /**
         * <p>
         * The timestamp at which the associated data was written to the database.
         * </p>
         * 
         * @param writeTime
         *        The timestamp at which the associated data was written to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeTime(String writeTime);
    }

    static final class BuilderImpl implements Builder {
        private String expirationTime;

        private String writeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesMetadata model) {
            expirationTime(model.expirationTime);
            writeTime(model.writeTime);
        }

        public final String getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getWriteTime() {
            return writeTime;
        }

        public final void setWriteTime(String writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public final Builder writeTime(String writeTime) {
            this.writeTime = writeTime;
            return this;
        }

        @Override
        public KeyspacesMetadata build() {
            return new KeyspacesMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
