/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a cell in an Amazon Keyspaces table, containing both the value and metadata about the cell.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyspacesCell implements SdkPojo, Serializable, ToCopyableBuilder<KeyspacesCell.Builder, KeyspacesCell> {
    private static final SdkField<KeyspacesCellValue> VALUE_FIELD = SdkField
            .<KeyspacesCellValue> builder(MarshallingType.SDK_POJO).memberName("value").getter(getter(KeyspacesCell::value))
            .setter(setter(Builder::value)).constructor(KeyspacesCellValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<KeyspacesMetadata> METADATA_FIELD = SdkField
            .<KeyspacesMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata").getter(getter(KeyspacesCell::metadata))
            .setter(setter(Builder::metadata)).constructor(KeyspacesMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KeyspacesCellValue value;

    private final KeyspacesMetadata metadata;

    private KeyspacesCell(BuilderImpl builder) {
        this.value = builder.value;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The value stored in this cell, which can be of various data types supported by Amazon Keyspaces.
     * </p>
     * 
     * @return The value stored in this cell, which can be of various data types supported by Amazon Keyspaces.
     */
    public final KeyspacesCellValue value() {
        return value;
    }

    /**
     * <p>
     * Metadata associated with this cell, such as time-to-live (TTL) expiration time and write timestamp.
     * </p>
     * 
     * @return Metadata associated with this cell, such as time-to-live (TTL) expiration time and write timestamp.
     */
    public final KeyspacesMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesCell)) {
            return false;
        }
        KeyspacesCell other = (KeyspacesCell) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyspacesCell").add("Value", value()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesCell, T> g) {
        return obj -> g.apply((KeyspacesCell) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyspacesCell> {
        /**
         * <p>
         * The value stored in this cell, which can be of various data types supported by Amazon Keyspaces.
         * </p>
         * 
         * @param value
         *        The value stored in this cell, which can be of various data types supported by Amazon Keyspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(KeyspacesCellValue value);

        /**
         * <p>
         * The value stored in this cell, which can be of various data types supported by Amazon Keyspaces.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyspacesCellValue.Builder} avoiding the
         * need to create one manually via {@link KeyspacesCellValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyspacesCellValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(KeyspacesCellValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link KeyspacesCellValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(KeyspacesCellValue)
         */
        default Builder value(Consumer<KeyspacesCellValue.Builder> value) {
            return value(KeyspacesCellValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * Metadata associated with this cell, such as time-to-live (TTL) expiration time and write timestamp.
         * </p>
         * 
         * @param metadata
         *        Metadata associated with this cell, such as time-to-live (TTL) expiration time and write timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(KeyspacesMetadata metadata);

        /**
         * <p>
         * Metadata associated with this cell, such as time-to-live (TTL) expiration time and write timestamp.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyspacesMetadata.Builder} avoiding the
         * need to create one manually via {@link KeyspacesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyspacesMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(KeyspacesMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link KeyspacesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(KeyspacesMetadata)
         */
        default Builder metadata(Consumer<KeyspacesMetadata.Builder> metadata) {
            return metadata(KeyspacesMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KeyspacesCellValue value;

        private KeyspacesMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesCell model) {
            value(model.value);
            metadata(model.metadata);
        }

        public final KeyspacesCellValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(KeyspacesCellValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(KeyspacesCellValue value) {
            this.value = value;
            return this;
        }

        public final KeyspacesMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(KeyspacesMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(KeyspacesMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public KeyspacesCell build() {
            return new KeyspacesCell(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
