/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecordsRequest extends KeyspacesStreamsRequest implements
        ToCopyableBuilder<GetRecordsRequest.Builder, GetRecordsRequest> {
    private static final SdkField<String> SHARD_ITERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shardIterator").getter(getter(GetRecordsRequest::shardIterator)).setter(setter(Builder::shardIterator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardIterator").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetRecordsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ITERATOR_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String shardIterator;

    private final Integer maxResults;

    private GetRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier of the shard iterator. A shard iterator specifies the position in the shard from which you
     * want to start reading data records sequentially. You obtain this value by calling the
     * <code>GetShardIterator</code> operation. Each shard iterator is valid for 15 minutes after creation.
     * </p>
     * 
     * @return The unique identifier of the shard iterator. A shard iterator specifies the position in the shard from
     *         which you want to start reading data records sequentially. You obtain this value by calling the
     *         <code>GetShardIterator</code> operation. Each shard iterator is valid for 15 minutes after creation.
     */
    public final String shardIterator() {
        return shardIterator;
    }

    /**
     * <p>
     * The maximum number of records to return in a single <code>GetRecords</code> request. Default value is 1000. You
     * can specify a limit between 1 and 1000, but the actual number returned might be less than the specified maximum
     * if the size of the data for the returned records exceeds the internal size limit.
     * </p>
     * 
     * @return The maximum number of records to return in a single <code>GetRecords</code> request. Default value is
     *         1000. You can specify a limit between 1 and 1000, but the actual number returned might be less than the
     *         specified maximum if the size of the data for the returned records exceeds the internal size limit.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsRequest)) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest) obj;
        return Objects.equals(shardIterator(), other.shardIterator()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecordsRequest").add("ShardIterator", shardIterator()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shardIterator":
            return Optional.ofNullable(clazz.cast(shardIterator()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("shardIterator", SHARD_ITERATOR_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsRequest, T> g) {
        return obj -> g.apply((GetRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRecordsRequest> {
        /**
         * <p>
         * The unique identifier of the shard iterator. A shard iterator specifies the position in the shard from which
         * you want to start reading data records sequentially. You obtain this value by calling the
         * <code>GetShardIterator</code> operation. Each shard iterator is valid for 15 minutes after creation.
         * </p>
         * 
         * @param shardIterator
         *        The unique identifier of the shard iterator. A shard iterator specifies the position in the shard from
         *        which you want to start reading data records sequentially. You obtain this value by calling the
         *        <code>GetShardIterator</code> operation. Each shard iterator is valid for 15 minutes after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardIterator(String shardIterator);

        /**
         * <p>
         * The maximum number of records to return in a single <code>GetRecords</code> request. Default value is 1000.
         * You can specify a limit between 1 and 1000, but the actual number returned might be less than the specified
         * maximum if the size of the data for the returned records exceeds the internal size limit.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records to return in a single <code>GetRecords</code> request. Default value is
         *        1000. You can specify a limit between 1 and 1000, but the actual number returned might be less than
         *        the specified maximum if the size of the data for the returned records exceeds the internal size
         *        limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesStreamsRequest.BuilderImpl implements Builder {
        private String shardIterator;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsRequest model) {
            super(model);
            shardIterator(model.shardIterator);
            maxResults(model.maxResults);
        }

        public final String getShardIterator() {
            return shardIterator;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
