/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellsCopier;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyspacesRow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyspacesRow> {
    private static final SdkField<Map<String, KeyspacesCell>> VALUE_CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("valueCells").getter(KeyspacesRow.getter(KeyspacesRow::valueCells)).setter(KeyspacesRow.setter(Builder::valueCells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueCells").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, KeyspacesCell>> STATIC_CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("staticCells").getter(KeyspacesRow.getter(KeyspacesRow::staticCells)).setter(KeyspacesRow.setter(Builder::staticCells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticCells").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KeyspacesMetadata> ROW_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rowMetadata").getter(KeyspacesRow.getter(KeyspacesRow::rowMetadata)).setter(KeyspacesRow.setter(Builder::rowMetadata)).constructor(KeyspacesMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_CELLS_FIELD, STATIC_CELLS_FIELD, ROW_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyspacesRow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, KeyspacesCell> valueCells;
    private final Map<String, KeyspacesCell> staticCells;
    private final KeyspacesMetadata rowMetadata;

    private KeyspacesRow(BuilderImpl builder) {
        this.valueCells = builder.valueCells;
        this.staticCells = builder.staticCells;
        this.rowMetadata = builder.rowMetadata;
    }

    public final boolean hasValueCells() {
        return this.valueCells != null && !(this.valueCells instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeyspacesCell> valueCells() {
        return this.valueCells;
    }

    public final boolean hasStaticCells() {
        return this.staticCells != null && !(this.staticCells instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeyspacesCell> staticCells() {
        return this.staticCells;
    }

    public final KeyspacesMetadata rowMetadata() {
        return this.rowMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueCells() ? this.valueCells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticCells() ? this.staticCells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesRow)) {
            return false;
        }
        KeyspacesRow other = (KeyspacesRow)obj;
        return this.hasValueCells() == other.hasValueCells() && Objects.equals(this.valueCells(), other.valueCells()) && this.hasStaticCells() == other.hasStaticCells() && Objects.equals(this.staticCells(), other.staticCells()) && Objects.equals(this.rowMetadata(), other.rowMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"KeyspacesRow").add("ValueCells", this.hasValueCells() ? this.valueCells() : null).add("StaticCells", this.hasStaticCells() ? this.staticCells() : null).add("RowMetadata", (Object)this.rowMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "valueCells": {
                return Optional.ofNullable(clazz.cast(this.valueCells()));
            }
            case "staticCells": {
                return Optional.ofNullable(clazz.cast(this.staticCells()));
            }
            case "rowMetadata": {
                return Optional.ofNullable(clazz.cast(this.rowMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("valueCells", VALUE_CELLS_FIELD);
        map.put("staticCells", STATIC_CELLS_FIELD);
        map.put("rowMetadata", ROW_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesRow, T> g) {
        return obj -> g.apply((KeyspacesRow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, KeyspacesCell> valueCells = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, KeyspacesCell> staticCells = DefaultSdkAutoConstructMap.getInstance();
        private KeyspacesMetadata rowMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesRow model) {
            this.valueCells(model.valueCells);
            this.staticCells(model.staticCells);
            this.rowMetadata(model.rowMetadata);
        }

        public final Map<String, KeyspacesCell.Builder> getValueCells() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesCellsCopier.copyToBuilder(this.valueCells);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueCells(Map<String, KeyspacesCell.BuilderImpl> valueCells) {
            this.valueCells = KeyspacesCellsCopier.copyFromBuilder(valueCells);
        }

        @Override
        public final Builder valueCells(Map<String, KeyspacesCell> valueCells) {
            this.valueCells = KeyspacesCellsCopier.copy(valueCells);
            return this;
        }

        public final Map<String, KeyspacesCell.Builder> getStaticCells() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesCellsCopier.copyToBuilder(this.staticCells);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStaticCells(Map<String, KeyspacesCell.BuilderImpl> staticCells) {
            this.staticCells = KeyspacesCellsCopier.copyFromBuilder(staticCells);
        }

        @Override
        public final Builder staticCells(Map<String, KeyspacesCell> staticCells) {
            this.staticCells = KeyspacesCellsCopier.copy(staticCells);
            return this;
        }

        public final KeyspacesMetadata.Builder getRowMetadata() {
            return this.rowMetadata != null ? this.rowMetadata.toBuilder() : null;
        }

        public final void setRowMetadata(KeyspacesMetadata.BuilderImpl rowMetadata) {
            this.rowMetadata = rowMetadata != null ? rowMetadata.build() : null;
        }

        @Override
        public final Builder rowMetadata(KeyspacesMetadata rowMetadata) {
            this.rowMetadata = rowMetadata;
            return this;
        }

        public KeyspacesRow build() {
            return new KeyspacesRow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyspacesRow> {
        public Builder valueCells(Map<String, KeyspacesCell> var1);

        public Builder staticCells(Map<String, KeyspacesCell> var1);

        public Builder rowMetadata(KeyspacesMetadata var1);

        default public Builder rowMetadata(Consumer<KeyspacesMetadata.Builder> rowMetadata) {
            return this.rowMetadata((KeyspacesMetadata)((KeyspacesMetadata.Builder)KeyspacesMetadata.builder().applyMutation(rowMetadata)).build());
        }
    }
}

