/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.FieldDefinition;
import software.amazon.awssdk.services.keyspaces.model.FieldListCopier;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.TableNameListCopier;
import software.amazon.awssdk.services.keyspaces.model.TypeNameListCopier;
import software.amazon.awssdk.services.keyspaces.model.TypeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTypeResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, GetTypeResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetTypeResponse.getter(GetTypeResponse::keyspaceName)).setter(GetTypeResponse.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(GetTypeResponse.getter(GetTypeResponse::typeName)).setter(GetTypeResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final SdkField<List<FieldDefinition>> FIELD_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldDefinitions").getter(GetTypeResponse.getter(GetTypeResponse::fieldDefinitions)).setter(GetTypeResponse.setter(Builder::fieldDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(GetTypeResponse.getter(GetTypeResponse::lastModifiedTimestamp)).setter(GetTypeResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTypeResponse.getter(GetTypeResponse::statusAsString)).setter(GetTypeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> DIRECT_REFERRING_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("directReferringTables").getter(GetTypeResponse.getter(GetTypeResponse::directReferringTables)).setter(GetTypeResponse.setter(Builder::directReferringTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directReferringTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DIRECT_PARENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("directParentTypes").getter(GetTypeResponse.getter(GetTypeResponse::directParentTypes)).setter(GetTypeResponse.setter(Builder::directParentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directParentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_NESTING_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxNestingDepth").getter(GetTypeResponse.getter(GetTypeResponse::maxNestingDepth)).setter(GetTypeResponse.setter(Builder::maxNestingDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNestingDepth").build()}).build();
    private static final SdkField<String> KEYSPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceArn").getter(GetTypeResponse.getter(GetTypeResponse::keyspaceArn)).setter(GetTypeResponse.setter(Builder::keyspaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TYPE_NAME_FIELD, FIELD_DEFINITIONS_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD, DIRECT_REFERRING_TABLES_FIELD, DIRECT_PARENT_TYPES_FIELD, MAX_NESTING_DEPTH_FIELD, KEYSPACE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTypeResponse.memberNameToFieldInitializer();
    private final String keyspaceName;
    private final String typeName;
    private final List<FieldDefinition> fieldDefinitions;
    private final Instant lastModifiedTimestamp;
    private final String status;
    private final List<String> directReferringTables;
    private final List<String> directParentTypes;
    private final Integer maxNestingDepth;
    private final String keyspaceArn;

    private GetTypeResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
        this.fieldDefinitions = builder.fieldDefinitions;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
        this.directReferringTables = builder.directReferringTables;
        this.directParentTypes = builder.directParentTypes;
        this.maxNestingDepth = builder.maxNestingDepth;
        this.keyspaceArn = builder.keyspaceArn;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final boolean hasFieldDefinitions() {
        return this.fieldDefinitions != null && !(this.fieldDefinitions instanceof SdkAutoConstructList);
    }

    public final List<FieldDefinition> fieldDefinitions() {
        return this.fieldDefinitions;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final TypeStatus status() {
        return TypeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasDirectReferringTables() {
        return this.directReferringTables != null && !(this.directReferringTables instanceof SdkAutoConstructList);
    }

    public final List<String> directReferringTables() {
        return this.directReferringTables;
    }

    public final boolean hasDirectParentTypes() {
        return this.directParentTypes != null && !(this.directParentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> directParentTypes() {
        return this.directParentTypes;
    }

    public final Integer maxNestingDepth() {
        return this.maxNestingDepth;
    }

    public final String keyspaceArn() {
        return this.keyspaceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldDefinitions() ? this.fieldDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectReferringTables() ? this.directReferringTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectParentTypes() ? this.directParentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNestingDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypeResponse)) {
            return false;
        }
        GetTypeResponse other = (GetTypeResponse)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.typeName(), other.typeName()) && this.hasFieldDefinitions() == other.hasFieldDefinitions() && Objects.equals(this.fieldDefinitions(), other.fieldDefinitions()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasDirectReferringTables() == other.hasDirectReferringTables() && Objects.equals(this.directReferringTables(), other.directReferringTables()) && this.hasDirectParentTypes() == other.hasDirectParentTypes() && Objects.equals(this.directParentTypes(), other.directParentTypes()) && Objects.equals(this.maxNestingDepth(), other.maxNestingDepth()) && Objects.equals(this.keyspaceArn(), other.keyspaceArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetTypeResponse").add("KeyspaceName", (Object)this.keyspaceName()).add("TypeName", (Object)this.typeName()).add("FieldDefinitions", this.hasFieldDefinitions() ? this.fieldDefinitions() : null).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Status", (Object)this.statusAsString()).add("DirectReferringTables", this.hasDirectReferringTables() ? this.directReferringTables() : null).add("DirectParentTypes", this.hasDirectParentTypes() ? this.directParentTypes() : null).add("MaxNestingDepth", (Object)this.maxNestingDepth()).add("KeyspaceArn", (Object)this.keyspaceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "fieldDefinitions": {
                return Optional.ofNullable(clazz.cast(this.fieldDefinitions()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "directReferringTables": {
                return Optional.ofNullable(clazz.cast(this.directReferringTables()));
            }
            case "directParentTypes": {
                return Optional.ofNullable(clazz.cast(this.directParentTypes()));
            }
            case "maxNestingDepth": {
                return Optional.ofNullable(clazz.cast(this.maxNestingDepth()));
            }
            case "keyspaceArn": {
                return Optional.ofNullable(clazz.cast(this.keyspaceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        map.put("fieldDefinitions", FIELD_DEFINITIONS_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("directReferringTables", DIRECT_REFERRING_TABLES_FIELD);
        map.put("directParentTypes", DIRECT_PARENT_TYPES_FIELD);
        map.put("maxNestingDepth", MAX_NESTING_DEPTH_FIELD);
        map.put("keyspaceArn", KEYSPACE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypeResponse, T> g) {
        return obj -> g.apply((GetTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String typeName;
        private List<FieldDefinition> fieldDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTimestamp;
        private String status;
        private List<String> directReferringTables = DefaultSdkAutoConstructList.getInstance();
        private List<String> directParentTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer maxNestingDepth;
        private String keyspaceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypeResponse model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.typeName(model.typeName);
            this.fieldDefinitions(model.fieldDefinitions);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.status(model.status);
            this.directReferringTables(model.directReferringTables);
            this.directParentTypes(model.directParentTypes);
            this.maxNestingDepth(model.maxNestingDepth);
            this.keyspaceArn(model.keyspaceArn);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<FieldDefinition.Builder> getFieldDefinitions() {
            List<FieldDefinition.Builder> result = FieldListCopier.copyToBuilder(this.fieldDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldDefinitions(Collection<FieldDefinition.BuilderImpl> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copyFromBuilder(fieldDefinitions);
        }

        @Override
        public final Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copy(fieldDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(FieldDefinition ... fieldDefinitions) {
            this.fieldDefinitions(Arrays.asList(fieldDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(Consumer<FieldDefinition.Builder> ... fieldDefinitions) {
            this.fieldDefinitions(Stream.of(fieldDefinitions).map(c -> (FieldDefinition)((FieldDefinition.Builder)FieldDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getDirectReferringTables() {
            if (this.directReferringTables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.directReferringTables;
        }

        public final void setDirectReferringTables(Collection<String> directReferringTables) {
            this.directReferringTables = TableNameListCopier.copy(directReferringTables);
        }

        @Override
        public final Builder directReferringTables(Collection<String> directReferringTables) {
            this.directReferringTables = TableNameListCopier.copy(directReferringTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directReferringTables(String ... directReferringTables) {
            this.directReferringTables(Arrays.asList(directReferringTables));
            return this;
        }

        public final Collection<String> getDirectParentTypes() {
            if (this.directParentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.directParentTypes;
        }

        public final void setDirectParentTypes(Collection<String> directParentTypes) {
            this.directParentTypes = TypeNameListCopier.copy(directParentTypes);
        }

        @Override
        public final Builder directParentTypes(Collection<String> directParentTypes) {
            this.directParentTypes = TypeNameListCopier.copy(directParentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directParentTypes(String ... directParentTypes) {
            this.directParentTypes(Arrays.asList(directParentTypes));
            return this;
        }

        public final Integer getMaxNestingDepth() {
            return this.maxNestingDepth;
        }

        public final void setMaxNestingDepth(Integer maxNestingDepth) {
            this.maxNestingDepth = maxNestingDepth;
        }

        @Override
        public final Builder maxNestingDepth(Integer maxNestingDepth) {
            this.maxNestingDepth = maxNestingDepth;
            return this;
        }

        public final String getKeyspaceArn() {
            return this.keyspaceArn;
        }

        public final void setKeyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
        }

        @Override
        public final Builder keyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
            return this;
        }

        @Override
        public GetTypeResponse build() {
            return new GetTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTypeResponse> {
        public Builder keyspaceName(String var1);

        public Builder typeName(String var1);

        public Builder fieldDefinitions(Collection<FieldDefinition> var1);

        public Builder fieldDefinitions(FieldDefinition ... var1);

        public Builder fieldDefinitions(Consumer<FieldDefinition.Builder> ... var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(TypeStatus var1);

        public Builder directReferringTables(Collection<String> var1);

        public Builder directReferringTables(String ... var1);

        public Builder directParentTypes(Collection<String> var1);

        public Builder directParentTypes(String ... var1);

        public Builder maxNestingDepth(Integer var1);

        public Builder keyspaceArn(String var1);
    }
}

