/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PointInTimeRecoverySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PointInTimeRecoverySummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PointInTimeRecoverySummary.getter(PointInTimeRecoverySummary::statusAsString)).setter(PointInTimeRecoverySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("earliestRestorableTimestamp").getter(PointInTimeRecoverySummary.getter(PointInTimeRecoverySummary::earliestRestorableTimestamp)).setter(PointInTimeRecoverySummary.setter(Builder::earliestRestorableTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("earliestRestorableTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, EARLIEST_RESTORABLE_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("earliestRestorableTimestamp", EARLIEST_RESTORABLE_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant earliestRestorableTimestamp;

    private PointInTimeRecoverySummary(BuilderImpl builder) {
        this.status = builder.status;
        this.earliestRestorableTimestamp = builder.earliestRestorableTimestamp;
    }

    public final PointInTimeRecoveryStatus status() {
        return PointInTimeRecoveryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant earliestRestorableTimestamp() {
        return this.earliestRestorableTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoverySummary)) {
            return false;
        }
        PointInTimeRecoverySummary other = (PointInTimeRecoverySummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.earliestRestorableTimestamp(), other.earliestRestorableTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PointInTimeRecoverySummary").add("Status", (Object)this.statusAsString()).add("EarliestRestorableTimestamp", (Object)this.earliestRestorableTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "earliestRestorableTimestamp": {
                return Optional.ofNullable(clazz.cast(this.earliestRestorableTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoverySummary, T> g) {
        return obj -> g.apply((PointInTimeRecoverySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant earliestRestorableTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoverySummary model) {
            this.status(model.status);
            this.earliestRestorableTimestamp(model.earliestRestorableTimestamp);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PointInTimeRecoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEarliestRestorableTimestamp() {
            return this.earliestRestorableTimestamp;
        }

        public final void setEarliestRestorableTimestamp(Instant earliestRestorableTimestamp) {
            this.earliestRestorableTimestamp = earliestRestorableTimestamp;
        }

        @Override
        public final Builder earliestRestorableTimestamp(Instant earliestRestorableTimestamp) {
            this.earliestRestorableTimestamp = earliestRestorableTimestamp;
            return this;
        }

        public PointInTimeRecoverySummary build() {
            return new PointInTimeRecoverySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PointInTimeRecoverySummary> {
        public Builder status(String var1);

        public Builder status(PointInTimeRecoveryStatus var1);

        public Builder earliestRestorableTimestamp(Instant var1);
    }
}

