/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.CapacitySpecification;
import software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery;
import software.amazon.awssdk.services.keyspaces.model.Tag;
import software.amazon.awssdk.services.keyspaces.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, RestoreTableRequest> {
    private static final SdkField<String> SOURCE_KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceKeyspaceName").getter(RestoreTableRequest.getter(RestoreTableRequest::sourceKeyspaceName)).setter(RestoreTableRequest.setter(Builder::sourceKeyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKeyspaceName").build()}).build();
    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceTableName").getter(RestoreTableRequest.getter(RestoreTableRequest::sourceTableName)).setter(RestoreTableRequest.setter(Builder::sourceTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTableName").build()}).build();
    private static final SdkField<String> TARGET_KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetKeyspaceName").getter(RestoreTableRequest.getter(RestoreTableRequest::targetKeyspaceName)).setter(RestoreTableRequest.setter(Builder::targetKeyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKeyspaceName").build()}).build();
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTableName").getter(RestoreTableRequest.getter(RestoreTableRequest::targetTableName)).setter(RestoreTableRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTableName").build()}).build();
    private static final SdkField<Instant> RESTORE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("restoreTimestamp").getter(RestoreTableRequest.getter(RestoreTableRequest::restoreTimestamp)).setter(RestoreTableRequest.setter(Builder::restoreTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreTimestamp").build()}).build();
    private static final SdkField<CapacitySpecification> CAPACITY_SPECIFICATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacitySpecificationOverride").getter(RestoreTableRequest.getter(RestoreTableRequest::capacitySpecificationOverride)).setter(RestoreTableRequest.setter(Builder::capacitySpecificationOverride)).constructor(CapacitySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecificationOverride").build()}).build();
    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionSpecificationOverride").getter(RestoreTableRequest.getter(RestoreTableRequest::encryptionSpecificationOverride)).setter(RestoreTableRequest.setter(Builder::encryptionSpecificationOverride)).constructor(EncryptionSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecificationOverride").build()}).build();
    private static final SdkField<PointInTimeRecovery> POINT_IN_TIME_RECOVERY_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pointInTimeRecoveryOverride").getter(RestoreTableRequest.getter(RestoreTableRequest::pointInTimeRecoveryOverride)).setter(RestoreTableRequest.setter(Builder::pointInTimeRecoveryOverride)).constructor(PointInTimeRecovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecoveryOverride").build()}).build();
    private static final SdkField<List<Tag>> TAGS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagsOverride").getter(RestoreTableRequest.getter(RestoreTableRequest::tagsOverride)).setter(RestoreTableRequest.setter(Builder::tagsOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagsOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_KEYSPACE_NAME_FIELD, SOURCE_TABLE_NAME_FIELD, TARGET_KEYSPACE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, RESTORE_TIMESTAMP_FIELD, CAPACITY_SPECIFICATION_OVERRIDE_FIELD, ENCRYPTION_SPECIFICATION_OVERRIDE_FIELD, POINT_IN_TIME_RECOVERY_OVERRIDE_FIELD, TAGS_OVERRIDE_FIELD));
    private final String sourceKeyspaceName;
    private final String sourceTableName;
    private final String targetKeyspaceName;
    private final String targetTableName;
    private final Instant restoreTimestamp;
    private final CapacitySpecification capacitySpecificationOverride;
    private final EncryptionSpecification encryptionSpecificationOverride;
    private final PointInTimeRecovery pointInTimeRecoveryOverride;
    private final List<Tag> tagsOverride;

    private RestoreTableRequest(BuilderImpl builder) {
        super(builder);
        this.sourceKeyspaceName = builder.sourceKeyspaceName;
        this.sourceTableName = builder.sourceTableName;
        this.targetKeyspaceName = builder.targetKeyspaceName;
        this.targetTableName = builder.targetTableName;
        this.restoreTimestamp = builder.restoreTimestamp;
        this.capacitySpecificationOverride = builder.capacitySpecificationOverride;
        this.encryptionSpecificationOverride = builder.encryptionSpecificationOverride;
        this.pointInTimeRecoveryOverride = builder.pointInTimeRecoveryOverride;
        this.tagsOverride = builder.tagsOverride;
    }

    public final String sourceKeyspaceName() {
        return this.sourceKeyspaceName;
    }

    public final String sourceTableName() {
        return this.sourceTableName;
    }

    public final String targetKeyspaceName() {
        return this.targetKeyspaceName;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public final Instant restoreTimestamp() {
        return this.restoreTimestamp;
    }

    public final CapacitySpecification capacitySpecificationOverride() {
        return this.capacitySpecificationOverride;
    }

    public final EncryptionSpecification encryptionSpecificationOverride() {
        return this.encryptionSpecificationOverride;
    }

    public final PointInTimeRecovery pointInTimeRecoveryOverride() {
        return this.pointInTimeRecoveryOverride;
    }

    public final boolean hasTagsOverride() {
        return this.tagsOverride != null && !(this.tagsOverride instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagsOverride() {
        return this.tagsOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacitySpecificationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSpecificationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecoveryOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsOverride() ? this.tagsOverride() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableRequest)) {
            return false;
        }
        RestoreTableRequest other = (RestoreTableRequest)((Object)obj);
        return Objects.equals(this.sourceKeyspaceName(), other.sourceKeyspaceName()) && Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetKeyspaceName(), other.targetKeyspaceName()) && Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.restoreTimestamp(), other.restoreTimestamp()) && Objects.equals(this.capacitySpecificationOverride(), other.capacitySpecificationOverride()) && Objects.equals(this.encryptionSpecificationOverride(), other.encryptionSpecificationOverride()) && Objects.equals(this.pointInTimeRecoveryOverride(), other.pointInTimeRecoveryOverride()) && this.hasTagsOverride() == other.hasTagsOverride() && Objects.equals(this.tagsOverride(), other.tagsOverride());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTableRequest").add("SourceKeyspaceName", (Object)this.sourceKeyspaceName()).add("SourceTableName", (Object)this.sourceTableName()).add("TargetKeyspaceName", (Object)this.targetKeyspaceName()).add("TargetTableName", (Object)this.targetTableName()).add("RestoreTimestamp", (Object)this.restoreTimestamp()).add("CapacitySpecificationOverride", (Object)this.capacitySpecificationOverride()).add("EncryptionSpecificationOverride", (Object)this.encryptionSpecificationOverride()).add("PointInTimeRecoveryOverride", (Object)this.pointInTimeRecoveryOverride()).add("TagsOverride", this.hasTagsOverride() ? this.tagsOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceKeyspaceName": {
                return Optional.ofNullable(clazz.cast(this.sourceKeyspaceName()));
            }
            case "sourceTableName": {
                return Optional.ofNullable(clazz.cast(this.sourceTableName()));
            }
            case "targetKeyspaceName": {
                return Optional.ofNullable(clazz.cast(this.targetKeyspaceName()));
            }
            case "targetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "restoreTimestamp": {
                return Optional.ofNullable(clazz.cast(this.restoreTimestamp()));
            }
            case "capacitySpecificationOverride": {
                return Optional.ofNullable(clazz.cast(this.capacitySpecificationOverride()));
            }
            case "encryptionSpecificationOverride": {
                return Optional.ofNullable(clazz.cast(this.encryptionSpecificationOverride()));
            }
            case "pointInTimeRecoveryOverride": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecoveryOverride()));
            }
            case "tagsOverride": {
                return Optional.ofNullable(clazz.cast(this.tagsOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableRequest, T> g) {
        return obj -> g.apply((RestoreTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String sourceKeyspaceName;
        private String sourceTableName;
        private String targetKeyspaceName;
        private String targetTableName;
        private Instant restoreTimestamp;
        private CapacitySpecification capacitySpecificationOverride;
        private EncryptionSpecification encryptionSpecificationOverride;
        private PointInTimeRecovery pointInTimeRecoveryOverride;
        private List<Tag> tagsOverride = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableRequest model) {
            super(model);
            this.sourceKeyspaceName(model.sourceKeyspaceName);
            this.sourceTableName(model.sourceTableName);
            this.targetKeyspaceName(model.targetKeyspaceName);
            this.targetTableName(model.targetTableName);
            this.restoreTimestamp(model.restoreTimestamp);
            this.capacitySpecificationOverride(model.capacitySpecificationOverride);
            this.encryptionSpecificationOverride(model.encryptionSpecificationOverride);
            this.pointInTimeRecoveryOverride(model.pointInTimeRecoveryOverride);
            this.tagsOverride(model.tagsOverride);
        }

        public final String getSourceKeyspaceName() {
            return this.sourceKeyspaceName;
        }

        public final void setSourceKeyspaceName(String sourceKeyspaceName) {
            this.sourceKeyspaceName = sourceKeyspaceName;
        }

        @Override
        @Transient
        public final Builder sourceKeyspaceName(String sourceKeyspaceName) {
            this.sourceKeyspaceName = sourceKeyspaceName;
            return this;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        @Transient
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetKeyspaceName() {
            return this.targetKeyspaceName;
        }

        public final void setTargetKeyspaceName(String targetKeyspaceName) {
            this.targetKeyspaceName = targetKeyspaceName;
        }

        @Override
        @Transient
        public final Builder targetKeyspaceName(String targetKeyspaceName) {
            this.targetKeyspaceName = targetKeyspaceName;
            return this;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        @Transient
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final Instant getRestoreTimestamp() {
            return this.restoreTimestamp;
        }

        public final void setRestoreTimestamp(Instant restoreTimestamp) {
            this.restoreTimestamp = restoreTimestamp;
        }

        @Override
        @Transient
        public final Builder restoreTimestamp(Instant restoreTimestamp) {
            this.restoreTimestamp = restoreTimestamp;
            return this;
        }

        public final CapacitySpecification.Builder getCapacitySpecificationOverride() {
            return this.capacitySpecificationOverride != null ? this.capacitySpecificationOverride.toBuilder() : null;
        }

        public final void setCapacitySpecificationOverride(CapacitySpecification.BuilderImpl capacitySpecificationOverride) {
            this.capacitySpecificationOverride = capacitySpecificationOverride != null ? capacitySpecificationOverride.build() : null;
        }

        @Override
        @Transient
        public final Builder capacitySpecificationOverride(CapacitySpecification capacitySpecificationOverride) {
            this.capacitySpecificationOverride = capacitySpecificationOverride;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecificationOverride() {
            return this.encryptionSpecificationOverride != null ? this.encryptionSpecificationOverride.toBuilder() : null;
        }

        public final void setEncryptionSpecificationOverride(EncryptionSpecification.BuilderImpl encryptionSpecificationOverride) {
            this.encryptionSpecificationOverride = encryptionSpecificationOverride != null ? encryptionSpecificationOverride.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionSpecificationOverride(EncryptionSpecification encryptionSpecificationOverride) {
            this.encryptionSpecificationOverride = encryptionSpecificationOverride;
            return this;
        }

        public final PointInTimeRecovery.Builder getPointInTimeRecoveryOverride() {
            return this.pointInTimeRecoveryOverride != null ? this.pointInTimeRecoveryOverride.toBuilder() : null;
        }

        public final void setPointInTimeRecoveryOverride(PointInTimeRecovery.BuilderImpl pointInTimeRecoveryOverride) {
            this.pointInTimeRecoveryOverride = pointInTimeRecoveryOverride != null ? pointInTimeRecoveryOverride.build() : null;
        }

        @Override
        @Transient
        public final Builder pointInTimeRecoveryOverride(PointInTimeRecovery pointInTimeRecoveryOverride) {
            this.pointInTimeRecoveryOverride = pointInTimeRecoveryOverride;
            return this;
        }

        public final List<Tag.Builder> getTagsOverride() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagsOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsOverride(Collection<Tag.BuilderImpl> tagsOverride) {
            this.tagsOverride = TagListCopier.copyFromBuilder(tagsOverride);
        }

        @Override
        @Transient
        public final Builder tagsOverride(Collection<Tag> tagsOverride) {
            this.tagsOverride = TagListCopier.copy(tagsOverride);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagsOverride(Tag ... tagsOverride) {
            this.tagsOverride(Arrays.asList(tagsOverride));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagsOverride(Consumer<Tag.Builder> ... tagsOverride) {
            this.tagsOverride(Stream.of(tagsOverride).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableRequest build() {
            return new RestoreTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableRequest> {
        public Builder sourceKeyspaceName(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetKeyspaceName(String var1);

        public Builder targetTableName(String var1);

        public Builder restoreTimestamp(Instant var1);

        public Builder capacitySpecificationOverride(CapacitySpecification var1);

        default public Builder capacitySpecificationOverride(Consumer<CapacitySpecification.Builder> capacitySpecificationOverride) {
            return this.capacitySpecificationOverride((CapacitySpecification)((CapacitySpecification.Builder)CapacitySpecification.builder().applyMutation(capacitySpecificationOverride)).build());
        }

        public Builder encryptionSpecificationOverride(EncryptionSpecification var1);

        default public Builder encryptionSpecificationOverride(Consumer<EncryptionSpecification.Builder> encryptionSpecificationOverride) {
            return this.encryptionSpecificationOverride((EncryptionSpecification)((EncryptionSpecification.Builder)EncryptionSpecification.builder().applyMutation(encryptionSpecificationOverride)).build());
        }

        public Builder pointInTimeRecoveryOverride(PointInTimeRecovery var1);

        default public Builder pointInTimeRecoveryOverride(Consumer<PointInTimeRecovery.Builder> pointInTimeRecoveryOverride) {
            return this.pointInTimeRecoveryOverride((PointInTimeRecovery)((PointInTimeRecovery.Builder)PointInTimeRecovery.builder().applyMutation(pointInTimeRecoveryOverride)).build());
        }

        public Builder tagsOverride(Collection<Tag> var1);

        public Builder tagsOverride(Tag ... var1);

        public Builder tagsOverride(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

