/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ClickFeedback;
import software.amazon.awssdk.services.kendra.model.ClickFeedbackListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.RelevanceFeedback;
import software.amazon.awssdk.services.kendra.model.RelevanceFeedbackListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitFeedbackRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, SubmitFeedbackRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::indexId)).setter(SubmitFeedbackRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::queryId)).setter(SubmitFeedbackRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<List<ClickFeedback>> CLICK_FEEDBACK_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClickFeedbackItems").getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::clickFeedbackItems)).setter(SubmitFeedbackRequest.setter(Builder::clickFeedbackItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClickFeedbackItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClickFeedback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RelevanceFeedback>> RELEVANCE_FEEDBACK_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelevanceFeedbackItems").getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::relevanceFeedbackItems)).setter(SubmitFeedbackRequest.setter(Builder::relevanceFeedbackItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelevanceFeedbackItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelevanceFeedback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, QUERY_ID_FIELD, CLICK_FEEDBACK_ITEMS_FIELD, RELEVANCE_FEEDBACK_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmitFeedbackRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String queryId;
    private final List<ClickFeedback> clickFeedbackItems;
    private final List<RelevanceFeedback> relevanceFeedbackItems;

    private SubmitFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryId = builder.queryId;
        this.clickFeedbackItems = builder.clickFeedbackItems;
        this.relevanceFeedbackItems = builder.relevanceFeedbackItems;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final boolean hasClickFeedbackItems() {
        return this.clickFeedbackItems != null && !(this.clickFeedbackItems instanceof SdkAutoConstructList);
    }

    public final List<ClickFeedback> clickFeedbackItems() {
        return this.clickFeedbackItems;
    }

    public final boolean hasRelevanceFeedbackItems() {
        return this.relevanceFeedbackItems != null && !(this.relevanceFeedbackItems instanceof SdkAutoConstructList);
    }

    public final List<RelevanceFeedback> relevanceFeedbackItems() {
        return this.relevanceFeedbackItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClickFeedbackItems() ? this.clickFeedbackItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelevanceFeedbackItems() ? this.relevanceFeedbackItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitFeedbackRequest)) {
            return false;
        }
        SubmitFeedbackRequest other = (SubmitFeedbackRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.queryId(), other.queryId()) && this.hasClickFeedbackItems() == other.hasClickFeedbackItems() && Objects.equals(this.clickFeedbackItems(), other.clickFeedbackItems()) && this.hasRelevanceFeedbackItems() == other.hasRelevanceFeedbackItems() && Objects.equals(this.relevanceFeedbackItems(), other.relevanceFeedbackItems());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitFeedbackRequest").add("IndexId", (Object)this.indexId()).add("QueryId", (Object)this.queryId()).add("ClickFeedbackItems", this.hasClickFeedbackItems() ? this.clickFeedbackItems() : null).add("RelevanceFeedbackItems", this.hasRelevanceFeedbackItems() ? this.relevanceFeedbackItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "ClickFeedbackItems": {
                return Optional.ofNullable(clazz.cast(this.clickFeedbackItems()));
            }
            case "RelevanceFeedbackItems": {
                return Optional.ofNullable(clazz.cast(this.relevanceFeedbackItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("ClickFeedbackItems", CLICK_FEEDBACK_ITEMS_FIELD);
        map.put("RelevanceFeedbackItems", RELEVANCE_FEEDBACK_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitFeedbackRequest, T> g) {
        return obj -> g.apply((SubmitFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String queryId;
        private List<ClickFeedback> clickFeedbackItems = DefaultSdkAutoConstructList.getInstance();
        private List<RelevanceFeedback> relevanceFeedbackItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitFeedbackRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.queryId(model.queryId);
            this.clickFeedbackItems(model.clickFeedbackItems);
            this.relevanceFeedbackItems(model.relevanceFeedbackItems);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<ClickFeedback.Builder> getClickFeedbackItems() {
            List<ClickFeedback.Builder> result = ClickFeedbackListCopier.copyToBuilder(this.clickFeedbackItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClickFeedbackItems(Collection<ClickFeedback.BuilderImpl> clickFeedbackItems) {
            this.clickFeedbackItems = ClickFeedbackListCopier.copyFromBuilder(clickFeedbackItems);
        }

        @Override
        public final Builder clickFeedbackItems(Collection<ClickFeedback> clickFeedbackItems) {
            this.clickFeedbackItems = ClickFeedbackListCopier.copy(clickFeedbackItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clickFeedbackItems(ClickFeedback ... clickFeedbackItems) {
            this.clickFeedbackItems(Arrays.asList(clickFeedbackItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clickFeedbackItems(Consumer<ClickFeedback.Builder> ... clickFeedbackItems) {
            this.clickFeedbackItems(Stream.of(clickFeedbackItems).map(c -> (ClickFeedback)((ClickFeedback.Builder)ClickFeedback.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RelevanceFeedback.Builder> getRelevanceFeedbackItems() {
            List<RelevanceFeedback.Builder> result = RelevanceFeedbackListCopier.copyToBuilder(this.relevanceFeedbackItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelevanceFeedbackItems(Collection<RelevanceFeedback.BuilderImpl> relevanceFeedbackItems) {
            this.relevanceFeedbackItems = RelevanceFeedbackListCopier.copyFromBuilder(relevanceFeedbackItems);
        }

        @Override
        public final Builder relevanceFeedbackItems(Collection<RelevanceFeedback> relevanceFeedbackItems) {
            this.relevanceFeedbackItems = RelevanceFeedbackListCopier.copy(relevanceFeedbackItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceFeedbackItems(RelevanceFeedback ... relevanceFeedbackItems) {
            this.relevanceFeedbackItems(Arrays.asList(relevanceFeedbackItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceFeedbackItems(Consumer<RelevanceFeedback.Builder> ... relevanceFeedbackItems) {
            this.relevanceFeedbackItems(Stream.of(relevanceFeedbackItems).map(c -> (RelevanceFeedback)((RelevanceFeedback.Builder)RelevanceFeedback.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitFeedbackRequest build() {
            return new SubmitFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitFeedbackRequest> {
        public Builder indexId(String var1);

        public Builder queryId(String var1);

        public Builder clickFeedbackItems(Collection<ClickFeedback> var1);

        public Builder clickFeedbackItems(ClickFeedback ... var1);

        public Builder clickFeedbackItems(Consumer<ClickFeedback.Builder> ... var1);

        public Builder relevanceFeedbackItems(Collection<RelevanceFeedback> var1);

        public Builder relevanceFeedbackItems(RelevanceFeedback ... var1);

        public Builder relevanceFeedbackItems(Consumer<RelevanceFeedback.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

