/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary;
import software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummaryListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessControlConfigurationsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListAccessControlConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessControlConfigurationsResponse.getter(ListAccessControlConfigurationsResponse::nextToken)).setter(ListAccessControlConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AccessControlConfigurationSummary>> ACCESS_CONTROL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlConfigurations").getter(ListAccessControlConfigurationsResponse.getter(ListAccessControlConfigurationsResponse::accessControlConfigurations)).setter(ListAccessControlConfigurationsResponse.setter(Builder::accessControlConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessControlConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_CONTROL_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessControlConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AccessControlConfigurationSummary> accessControlConfigurations;

    private ListAccessControlConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessControlConfigurations = builder.accessControlConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessControlConfigurations() {
        return this.accessControlConfigurations != null && !(this.accessControlConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AccessControlConfigurationSummary> accessControlConfigurations() {
        return this.accessControlConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlConfigurations() ? this.accessControlConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessControlConfigurationsResponse)) {
            return false;
        }
        ListAccessControlConfigurationsResponse other = (ListAccessControlConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessControlConfigurations() == other.hasAccessControlConfigurations() && Objects.equals(this.accessControlConfigurations(), other.accessControlConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessControlConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("AccessControlConfigurations", this.hasAccessControlConfigurations() ? this.accessControlConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AccessControlConfigurations": {
                return Optional.ofNullable(clazz.cast(this.accessControlConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AccessControlConfigurations", ACCESS_CONTROL_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessControlConfigurationsResponse, T> g) {
        return obj -> g.apply((ListAccessControlConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AccessControlConfigurationSummary> accessControlConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessControlConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessControlConfigurations(model.accessControlConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AccessControlConfigurationSummary.Builder> getAccessControlConfigurations() {
            List<AccessControlConfigurationSummary.Builder> result = AccessControlConfigurationSummaryListCopier.copyToBuilder(this.accessControlConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlConfigurations(Collection<AccessControlConfigurationSummary.BuilderImpl> accessControlConfigurations) {
            this.accessControlConfigurations = AccessControlConfigurationSummaryListCopier.copyFromBuilder(accessControlConfigurations);
        }

        @Override
        public final Builder accessControlConfigurations(Collection<AccessControlConfigurationSummary> accessControlConfigurations) {
            this.accessControlConfigurations = AccessControlConfigurationSummaryListCopier.copy(accessControlConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlConfigurations(AccessControlConfigurationSummary ... accessControlConfigurations) {
            this.accessControlConfigurations(Arrays.asList(accessControlConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlConfigurations(Consumer<AccessControlConfigurationSummary.Builder> ... accessControlConfigurations) {
            this.accessControlConfigurations(Stream.of(accessControlConfigurations).map(c -> (AccessControlConfigurationSummary)((AccessControlConfigurationSummary.Builder)AccessControlConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessControlConfigurationsResponse build() {
            return new ListAccessControlConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessControlConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder accessControlConfigurations(Collection<AccessControlConfigurationSummary> var1);

        public Builder accessControlConfigurations(AccessControlConfigurationSummary ... var1);

        public Builder accessControlConfigurations(Consumer<AccessControlConfigurationSummary.Builder> ... var1);
    }
}

