/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeKeyListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceDocument> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(SourceDocument.getter(SourceDocument::documentId)).setter(SourceDocument.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<List<String>> SUGGESTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestionAttributes").getter(SourceDocument.getter(SourceDocument::suggestionAttributes)).setter(SourceDocument.setter(Builder::suggestionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAttributes").getter(SourceDocument.getter(SourceDocument::additionalAttributes)).setter(SourceDocument.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD, SUGGESTION_ATTRIBUTES_FIELD, ADDITIONAL_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentId", DOCUMENT_ID_FIELD);
            this.put("SuggestionAttributes", SUGGESTION_ATTRIBUTES_FIELD);
            this.put("AdditionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String documentId;
    private final List<String> suggestionAttributes;
    private final List<DocumentAttribute> additionalAttributes;

    private SourceDocument(BuilderImpl builder) {
        this.documentId = builder.documentId;
        this.suggestionAttributes = builder.suggestionAttributes;
        this.additionalAttributes = builder.additionalAttributes;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final boolean hasSuggestionAttributes() {
        return this.suggestionAttributes != null && !(this.suggestionAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> suggestionAttributes() {
        return this.suggestionAttributes;
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestionAttributes() ? this.suggestionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDocument)) {
            return false;
        }
        SourceDocument other = (SourceDocument)obj;
        return Objects.equals(this.documentId(), other.documentId()) && this.hasSuggestionAttributes() == other.hasSuggestionAttributes() && Objects.equals(this.suggestionAttributes(), other.suggestionAttributes()) && this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributes(), other.additionalAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"SourceDocument").add("DocumentId", (Object)this.documentId()).add("SuggestionAttributes", this.hasSuggestionAttributes() ? this.suggestionAttributes() : null).add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "SuggestionAttributes": {
                return Optional.ofNullable(clazz.cast(this.suggestionAttributes()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceDocument, T> g) {
        return obj -> g.apply((SourceDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentId;
        private List<String> suggestionAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDocument model) {
            this.documentId(model.documentId);
            this.suggestionAttributes(model.suggestionAttributes);
            this.additionalAttributes(model.additionalAttributes);
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final Collection<String> getSuggestionAttributes() {
            if (this.suggestionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suggestionAttributes;
        }

        public final void setSuggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
        }

        @Override
        public final Builder suggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionAttributes(String ... suggestionAttributes) {
            this.suggestionAttributes(Arrays.asList(suggestionAttributes));
            return this;
        }

        public final List<DocumentAttribute.Builder> getAdditionalAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<DocumentAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = DocumentAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<DocumentAttribute> additionalAttributes) {
            this.additionalAttributes = DocumentAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(DocumentAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<DocumentAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SourceDocument build() {
            return new SourceDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceDocument> {
        public Builder documentId(String var1);

        public Builder suggestionAttributes(Collection<String> var1);

        public Builder suggestionAttributes(String ... var1);

        public Builder additionalAttributes(Collection<DocumentAttribute> var1);

        public Builder additionalAttributes(DocumentAttribute ... var1);

        public Builder additionalAttributes(Consumer<DocumentAttribute.Builder> ... var1);
    }
}

