/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.ProxyConfiguration;
import software.amazon.awssdk.services.kendra.model.Urls;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebCrawlerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebCrawlerConfiguration> {
    private static final SdkField<Urls> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Urls").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::urls)).setter(WebCrawlerConfiguration.setter(Builder::urls)).constructor(Urls::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build()}).build();
    private static final SdkField<Integer> CRAWL_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CrawlDepth").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::crawlDepth)).setter(WebCrawlerConfiguration.setter(Builder::crawlDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlDepth").build()}).build();
    private static final SdkField<Integer> MAX_LINKS_PER_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLinksPerPage").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::maxLinksPerPage)).setter(WebCrawlerConfiguration.setter(Builder::maxLinksPerPage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLinksPerPage").build()}).build();
    private static final SdkField<Float> MAX_CONTENT_SIZE_PER_PAGE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MaxContentSizePerPageInMegaBytes").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::maxContentSizePerPageInMegaBytes)).setter(WebCrawlerConfiguration.setter(Builder::maxContentSizePerPageInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContentSizePerPageInMegaBytes").build()}).build();
    private static final SdkField<Integer> MAX_URLS_PER_MINUTE_CRAWL_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUrlsPerMinuteCrawlRate").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::maxUrlsPerMinuteCrawlRate)).setter(WebCrawlerConfiguration.setter(Builder::maxUrlsPerMinuteCrawlRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUrlsPerMinuteCrawlRate").build()}).build();
    private static final SdkField<List<String>> URL_INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UrlInclusionPatterns").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::urlInclusionPatterns)).setter(WebCrawlerConfiguration.setter(Builder::urlInclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlInclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> URL_EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UrlExclusionPatterns").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::urlExclusionPatterns)).setter(WebCrawlerConfiguration.setter(Builder::urlExclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProxyConfiguration").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::proxyConfiguration)).setter(WebCrawlerConfiguration.setter(Builder::proxyConfiguration)).constructor(ProxyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfiguration").build()}).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::authenticationConfiguration)).setter(WebCrawlerConfiguration.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, CRAWL_DEPTH_FIELD, MAX_LINKS_PER_PAGE_FIELD, MAX_CONTENT_SIZE_PER_PAGE_IN_MEGA_BYTES_FIELD, MAX_URLS_PER_MINUTE_CRAWL_RATE_FIELD, URL_INCLUSION_PATTERNS_FIELD, URL_EXCLUSION_PATTERNS_FIELD, PROXY_CONFIGURATION_FIELD, AUTHENTICATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Urls", URLS_FIELD);
            this.put("CrawlDepth", CRAWL_DEPTH_FIELD);
            this.put("MaxLinksPerPage", MAX_LINKS_PER_PAGE_FIELD);
            this.put("MaxContentSizePerPageInMegaBytes", MAX_CONTENT_SIZE_PER_PAGE_IN_MEGA_BYTES_FIELD);
            this.put("MaxUrlsPerMinuteCrawlRate", MAX_URLS_PER_MINUTE_CRAWL_RATE_FIELD);
            this.put("UrlInclusionPatterns", URL_INCLUSION_PATTERNS_FIELD);
            this.put("UrlExclusionPatterns", URL_EXCLUSION_PATTERNS_FIELD);
            this.put("ProxyConfiguration", PROXY_CONFIGURATION_FIELD);
            this.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Urls urls;
    private final Integer crawlDepth;
    private final Integer maxLinksPerPage;
    private final Float maxContentSizePerPageInMegaBytes;
    private final Integer maxUrlsPerMinuteCrawlRate;
    private final List<String> urlInclusionPatterns;
    private final List<String> urlExclusionPatterns;
    private final ProxyConfiguration proxyConfiguration;
    private final AuthenticationConfiguration authenticationConfiguration;

    private WebCrawlerConfiguration(BuilderImpl builder) {
        this.urls = builder.urls;
        this.crawlDepth = builder.crawlDepth;
        this.maxLinksPerPage = builder.maxLinksPerPage;
        this.maxContentSizePerPageInMegaBytes = builder.maxContentSizePerPageInMegaBytes;
        this.maxUrlsPerMinuteCrawlRate = builder.maxUrlsPerMinuteCrawlRate;
        this.urlInclusionPatterns = builder.urlInclusionPatterns;
        this.urlExclusionPatterns = builder.urlExclusionPatterns;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.authenticationConfiguration = builder.authenticationConfiguration;
    }

    public final Urls urls() {
        return this.urls;
    }

    public final Integer crawlDepth() {
        return this.crawlDepth;
    }

    public final Integer maxLinksPerPage() {
        return this.maxLinksPerPage;
    }

    public final Float maxContentSizePerPageInMegaBytes() {
        return this.maxContentSizePerPageInMegaBytes;
    }

    public final Integer maxUrlsPerMinuteCrawlRate() {
        return this.maxUrlsPerMinuteCrawlRate;
    }

    public final boolean hasUrlInclusionPatterns() {
        return this.urlInclusionPatterns != null && !(this.urlInclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> urlInclusionPatterns() {
        return this.urlInclusionPatterns;
    }

    public final boolean hasUrlExclusionPatterns() {
        return this.urlExclusionPatterns != null && !(this.urlExclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> urlExclusionPatterns() {
        return this.urlExclusionPatterns;
    }

    public final ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.urls());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLinksPerPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxContentSizePerPageInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUrlsPerMinuteCrawlRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrlInclusionPatterns() ? this.urlInclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrlExclusionPatterns() ? this.urlExclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerConfiguration)) {
            return false;
        }
        WebCrawlerConfiguration other = (WebCrawlerConfiguration)obj;
        return Objects.equals(this.urls(), other.urls()) && Objects.equals(this.crawlDepth(), other.crawlDepth()) && Objects.equals(this.maxLinksPerPage(), other.maxLinksPerPage()) && Objects.equals(this.maxContentSizePerPageInMegaBytes(), other.maxContentSizePerPageInMegaBytes()) && Objects.equals(this.maxUrlsPerMinuteCrawlRate(), other.maxUrlsPerMinuteCrawlRate()) && this.hasUrlInclusionPatterns() == other.hasUrlInclusionPatterns() && Objects.equals(this.urlInclusionPatterns(), other.urlInclusionPatterns()) && this.hasUrlExclusionPatterns() == other.hasUrlExclusionPatterns() && Objects.equals(this.urlExclusionPatterns(), other.urlExclusionPatterns()) && Objects.equals(this.proxyConfiguration(), other.proxyConfiguration()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"WebCrawlerConfiguration").add("Urls", (Object)this.urls()).add("CrawlDepth", (Object)this.crawlDepth()).add("MaxLinksPerPage", (Object)this.maxLinksPerPage()).add("MaxContentSizePerPageInMegaBytes", (Object)this.maxContentSizePerPageInMegaBytes()).add("MaxUrlsPerMinuteCrawlRate", (Object)this.maxUrlsPerMinuteCrawlRate()).add("UrlInclusionPatterns", this.hasUrlInclusionPatterns() ? this.urlInclusionPatterns() : null).add("UrlExclusionPatterns", this.hasUrlExclusionPatterns() ? this.urlExclusionPatterns() : null).add("ProxyConfiguration", (Object)this.proxyConfiguration()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "CrawlDepth": {
                return Optional.ofNullable(clazz.cast(this.crawlDepth()));
            }
            case "MaxLinksPerPage": {
                return Optional.ofNullable(clazz.cast(this.maxLinksPerPage()));
            }
            case "MaxContentSizePerPageInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.maxContentSizePerPageInMegaBytes()));
            }
            case "MaxUrlsPerMinuteCrawlRate": {
                return Optional.ofNullable(clazz.cast(this.maxUrlsPerMinuteCrawlRate()));
            }
            case "UrlInclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.urlInclusionPatterns()));
            }
            case "UrlExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.urlExclusionPatterns()));
            }
            case "ProxyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proxyConfiguration()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WebCrawlerConfiguration, T> g) {
        return obj -> g.apply((WebCrawlerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Urls urls;
        private Integer crawlDepth;
        private Integer maxLinksPerPage;
        private Float maxContentSizePerPageInMegaBytes;
        private Integer maxUrlsPerMinuteCrawlRate;
        private List<String> urlInclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> urlExclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private ProxyConfiguration proxyConfiguration;
        private AuthenticationConfiguration authenticationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WebCrawlerConfiguration model) {
            this.urls(model.urls);
            this.crawlDepth(model.crawlDepth);
            this.maxLinksPerPage(model.maxLinksPerPage);
            this.maxContentSizePerPageInMegaBytes(model.maxContentSizePerPageInMegaBytes);
            this.maxUrlsPerMinuteCrawlRate(model.maxUrlsPerMinuteCrawlRate);
            this.urlInclusionPatterns(model.urlInclusionPatterns);
            this.urlExclusionPatterns(model.urlExclusionPatterns);
            this.proxyConfiguration(model.proxyConfiguration);
            this.authenticationConfiguration(model.authenticationConfiguration);
        }

        public final Urls.Builder getUrls() {
            return this.urls != null ? this.urls.toBuilder() : null;
        }

        public final void setUrls(Urls.BuilderImpl urls) {
            this.urls = urls != null ? urls.build() : null;
        }

        @Override
        public final Builder urls(Urls urls) {
            this.urls = urls;
            return this;
        }

        public final Integer getCrawlDepth() {
            return this.crawlDepth;
        }

        public final void setCrawlDepth(Integer crawlDepth) {
            this.crawlDepth = crawlDepth;
        }

        @Override
        public final Builder crawlDepth(Integer crawlDepth) {
            this.crawlDepth = crawlDepth;
            return this;
        }

        public final Integer getMaxLinksPerPage() {
            return this.maxLinksPerPage;
        }

        public final void setMaxLinksPerPage(Integer maxLinksPerPage) {
            this.maxLinksPerPage = maxLinksPerPage;
        }

        @Override
        public final Builder maxLinksPerPage(Integer maxLinksPerPage) {
            this.maxLinksPerPage = maxLinksPerPage;
            return this;
        }

        public final Float getMaxContentSizePerPageInMegaBytes() {
            return this.maxContentSizePerPageInMegaBytes;
        }

        public final void setMaxContentSizePerPageInMegaBytes(Float maxContentSizePerPageInMegaBytes) {
            this.maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes;
        }

        @Override
        public final Builder maxContentSizePerPageInMegaBytes(Float maxContentSizePerPageInMegaBytes) {
            this.maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes;
            return this;
        }

        public final Integer getMaxUrlsPerMinuteCrawlRate() {
            return this.maxUrlsPerMinuteCrawlRate;
        }

        public final void setMaxUrlsPerMinuteCrawlRate(Integer maxUrlsPerMinuteCrawlRate) {
            this.maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate;
        }

        @Override
        public final Builder maxUrlsPerMinuteCrawlRate(Integer maxUrlsPerMinuteCrawlRate) {
            this.maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate;
            return this;
        }

        public final Collection<String> getUrlInclusionPatterns() {
            if (this.urlInclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urlInclusionPatterns;
        }

        public final void setUrlInclusionPatterns(Collection<String> urlInclusionPatterns) {
            this.urlInclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(urlInclusionPatterns);
        }

        @Override
        public final Builder urlInclusionPatterns(Collection<String> urlInclusionPatterns) {
            this.urlInclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(urlInclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urlInclusionPatterns(String ... urlInclusionPatterns) {
            this.urlInclusionPatterns(Arrays.asList(urlInclusionPatterns));
            return this;
        }

        public final Collection<String> getUrlExclusionPatterns() {
            if (this.urlExclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urlExclusionPatterns;
        }

        public final void setUrlExclusionPatterns(Collection<String> urlExclusionPatterns) {
            this.urlExclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(urlExclusionPatterns);
        }

        @Override
        public final Builder urlExclusionPatterns(Collection<String> urlExclusionPatterns) {
            this.urlExclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(urlExclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urlExclusionPatterns(String ... urlExclusionPatterns) {
            this.urlExclusionPatterns(Arrays.asList(urlExclusionPatterns));
            return this;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return this.proxyConfiguration != null ? this.proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public WebCrawlerConfiguration build() {
            return new WebCrawlerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebCrawlerConfiguration> {
        public Builder urls(Urls var1);

        default public Builder urls(Consumer<Urls.Builder> urls) {
            return this.urls((Urls)((Urls.Builder)Urls.builder().applyMutation(urls)).build());
        }

        public Builder crawlDepth(Integer var1);

        public Builder maxLinksPerPage(Integer var1);

        public Builder maxContentSizePerPageInMegaBytes(Float var1);

        public Builder maxUrlsPerMinuteCrawlRate(Integer var1);

        public Builder urlInclusionPatterns(Collection<String> var1);

        public Builder urlInclusionPatterns(String ... var1);

        public Builder urlExclusionPatterns(Collection<String> var1);

        public Builder urlExclusionPatterns(String ... var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        default public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return this.proxyConfiguration((ProxyConfiguration)((ProxyConfiguration.Builder)ProxyConfiguration.builder().applyMutation(proxyConfiguration)).build());
        }

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }
    }
}

