/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.RetrieveResultItem;
import software.amazon.awssdk.services.kendra.model.RetrieveResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, RetrieveResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(RetrieveResponse.getter(RetrieveResponse::queryId)).setter(RetrieveResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<List<RetrieveResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(RetrieveResponse.getter(RetrieveResponse::resultItems)).setter(RetrieveResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrieveResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, RESULT_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueryId", QUERY_ID_FIELD);
            this.put("ResultItems", RESULT_ITEMS_FIELD);
        }
    });
    private final String queryId;
    private final List<RetrieveResultItem> resultItems;

    private RetrieveResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.resultItems = builder.resultItems;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<RetrieveResultItem> resultItems() {
        return this.resultItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResponse)) {
            return false;
        }
        RetrieveResponse other = (RetrieveResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveResponse").add("QueryId", (Object)this.queryId()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResponse, T> g) {
        return obj -> g.apply((RetrieveResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private List<RetrieveResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.resultItems(model.resultItems);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<RetrieveResultItem.Builder> getResultItems() {
            List<RetrieveResultItem.Builder> result = RetrieveResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<RetrieveResultItem.BuilderImpl> resultItems) {
            this.resultItems = RetrieveResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<RetrieveResultItem> resultItems) {
            this.resultItems = RetrieveResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(RetrieveResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<RetrieveResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (RetrieveResultItem)((RetrieveResultItem.Builder)RetrieveResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetrieveResponse build() {
            return new RetrieveResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveResponse> {
        public Builder queryId(String var1);

        public Builder resultItems(Collection<RetrieveResultItem> var1);

        public Builder resultItems(RetrieveResultItem ... var1);

        public Builder resultItems(Consumer<RetrieveResultItem.Builder> ... var1);
    }
}

