/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SortingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SortingConfiguration> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentAttributeKey").getter(SortingConfiguration.getter(SortingConfiguration::documentAttributeKey)).setter(SortingConfiguration.setter(Builder::documentAttributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(SortingConfiguration.getter(SortingConfiguration::sortOrderAsString)).setter(SortingConfiguration.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentAttributeKey;
    private final String sortOrder;

    private SortingConfiguration(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.sortOrder = builder.sortOrder;
    }

    public final String documentAttributeKey() {
        return this.documentAttributeKey;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortingConfiguration)) {
            return false;
        }
        SortingConfiguration other = (SortingConfiguration)obj;
        return Objects.equals(this.documentAttributeKey(), other.documentAttributeKey()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SortingConfiguration").add("DocumentAttributeKey", (Object)this.documentAttributeKey()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttributeKey": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeKey()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortingConfiguration, T> g) {
        return obj -> g.apply((SortingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentAttributeKey;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SortingConfiguration model) {
            this.documentAttributeKey(model.documentAttributeKey);
            this.sortOrder(model.sortOrder);
        }

        public final String getDocumentAttributeKey() {
            return this.documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public SortingConfiguration build() {
            return new SortingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SortingConfiguration> {
        public Builder documentAttributeKey(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

