/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelevanceType {
    RELEVANT("RELEVANT"),
    NOT_RELEVANT("NOT_RELEVANT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelevanceType> VALUE_MAP;
    private final String value;

    private RelevanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelevanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelevanceType> knownValues() {
        EnumSet<RelevanceType> knownValues = EnumSet.allOf(RelevanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelevanceType.class, RelevanceType::toString);
    }
}

