/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateIndexRequest.Builder, UpdateIndexRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateIndexRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateIndexRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateIndexRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD = SdkField
            .<List<DocumentMetadataConfiguration>> builder(MarshallingType.LIST)
            .memberName("DocumentMetadataConfigurationUpdates")
            .getter(getter(UpdateIndexRequest::documentMetadataConfigurationUpdates))
            .setter(setter(Builder::documentMetadataConfigurationUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DocumentMetadataConfigurationUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentMetadataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentMetadataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField
            .<CapacityUnitsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CapacityUnits")
            .getter(getter(UpdateIndexRequest::capacityUnits)).setter(setter(Builder::capacityUnits))
            .constructor(CapacityUnitsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final SdkField<List<UserTokenConfiguration>> USER_TOKEN_CONFIGURATIONS_FIELD = SdkField
            .<List<UserTokenConfiguration>> builder(MarshallingType.LIST)
            .memberName("UserTokenConfigurations")
            .getter(getter(UpdateIndexRequest::userTokenConfigurations))
            .setter(setter(Builder::userTokenConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTokenConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserTokenConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserTokenConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_CONTEXT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserContextPolicy").getter(getter(UpdateIndexRequest::userContextPolicyAsString))
            .setter(setter(Builder::userContextPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextPolicy").build()).build();

    private static final SdkField<UserGroupResolutionConfiguration> USER_GROUP_RESOLUTION_CONFIGURATION_FIELD = SdkField
            .<UserGroupResolutionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UserGroupResolutionConfiguration")
            .getter(getter(UpdateIndexRequest::userGroupResolutionConfiguration))
            .setter(setter(Builder::userGroupResolutionConfiguration))
            .constructor(UserGroupResolutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ROLE_ARN_FIELD, DESCRIPTION_FIELD, DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD, CAPACITY_UNITS_FIELD,
            USER_TOKEN_CONFIGURATIONS_FIELD, USER_CONTEXT_POLICY_FIELD, USER_GROUP_RESOLUTION_CONFIGURATION_FIELD));

    private final String id;

    private final String name;

    private final String roleArn;

    private final String description;

    private final List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates;

    private final CapacityUnitsConfiguration capacityUnits;

    private final List<UserTokenConfiguration> userTokenConfigurations;

    private final String userContextPolicy;

    private final UserGroupResolutionConfiguration userGroupResolutionConfiguration;

    private UpdateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.documentMetadataConfigurationUpdates = builder.documentMetadataConfigurationUpdates;
        this.capacityUnits = builder.capacityUnits;
        this.userTokenConfigurations = builder.userTokenConfigurations;
        this.userContextPolicy = builder.userContextPolicy;
        this.userGroupResolutionConfiguration = builder.userGroupResolutionConfiguration;
    }

    /**
     * <p>
     * The identifier of the index you want to update.
     * </p>
     * 
     * @return The identifier of the index you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the index you want to update.
     * </p>
     * 
     * @return The name of the index you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon CloudWatch logs
     * and metrics.
     * </p>
     * 
     * @return An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon
     *         CloudWatch logs and metrics.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A new description for the index.
     * </p>
     * 
     * @return A new description for the index.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentMetadataConfigurationUpdates
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentMetadataConfigurationUpdates() {
        return documentMetadataConfigurationUpdates != null
                && !(documentMetadataConfigurationUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document metadata configuration you want to update for the index. Document metadata are fields or attributes
     * associated with your documents. For example, the company department name associated with each document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentMetadataConfigurationUpdates}
     * method.
     * </p>
     * 
     * @return The document metadata configuration you want to update for the index. Document metadata are fields or
     *         attributes associated with your documents. For example, the company department name associated with each
     *         document.
     */
    public final List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates() {
        return documentMetadataConfigurationUpdates;
    }

    /**
     * <p>
     * Sets the number of additional document storage and query capacity units that should be used by the index. You can
     * change the capacity of the index up to 5 times per day, or make 5 API calls.
     * </p>
     * <p>
     * If you are using extra storage units, you can't reduce the storage capacity below what is required to meet the
     * storage needs for your index.
     * </p>
     * 
     * @return Sets the number of additional document storage and query capacity units that should be used by the index.
     *         You can change the capacity of the index up to 5 times per day, or make 5 API calls.</p>
     *         <p>
     *         If you are using extra storage units, you can't reduce the storage capacity below what is required to
     *         meet the storage needs for your index.
     */
    public final CapacityUnitsConfiguration capacityUnits() {
        return capacityUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserTokenConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserTokenConfigurations() {
        return userTokenConfigurations != null && !(userTokenConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user token configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserTokenConfigurations} method.
     * </p>
     * 
     * @return The user token configuration.
     */
    public final List<UserTokenConfiguration> userTokenConfigurations() {
        return userTokenConfigurations;
    }

    /**
     * <p>
     * The user context policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy.
     * @see UserContextPolicy
     */
    public final UserContextPolicy userContextPolicy() {
        return UserContextPolicy.fromValue(userContextPolicy);
    }

    /**
     * <p>
     * The user context policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy.
     * @see UserContextPolicy
     */
    public final String userContextPolicyAsString() {
        return userContextPolicy;
    }

    /**
     * <p>
     * Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On)
     * identity source. To configure this, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
     * >UserGroupResolutionConfiguration</a>.
     * </p>
     * 
     * @return Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single
     *         Sign-On) identity source. To configure this, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
     *         >UserGroupResolutionConfiguration</a>.
     */
    public final UserGroupResolutionConfiguration userGroupResolutionConfiguration() {
        return userGroupResolutionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentMetadataConfigurationUpdates() ? documentMetadataConfigurationUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserTokenConfigurations() ? userTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userContextPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupResolutionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexRequest)) {
            return false;
        }
        UpdateIndexRequest other = (UpdateIndexRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description())
                && hasDocumentMetadataConfigurationUpdates() == other.hasDocumentMetadataConfigurationUpdates()
                && Objects.equals(documentMetadataConfigurationUpdates(), other.documentMetadataConfigurationUpdates())
                && Objects.equals(capacityUnits(), other.capacityUnits())
                && hasUserTokenConfigurations() == other.hasUserTokenConfigurations()
                && Objects.equals(userTokenConfigurations(), other.userTokenConfigurations())
                && Objects.equals(userContextPolicyAsString(), other.userContextPolicyAsString())
                && Objects.equals(userGroupResolutionConfiguration(), other.userGroupResolutionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateIndexRequest")
                .add("Id", id())
                .add("Name", name())
                .add("RoleArn", roleArn())
                .add("Description", description())
                .add("DocumentMetadataConfigurationUpdates",
                        hasDocumentMetadataConfigurationUpdates() ? documentMetadataConfigurationUpdates() : null)
                .add("CapacityUnits", capacityUnits())
                .add("UserTokenConfigurations", hasUserTokenConfigurations() ? userTokenConfigurations() : null)
                .add("UserContextPolicy", userContextPolicyAsString())
                .add("UserGroupResolutionConfiguration", userGroupResolutionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DocumentMetadataConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(documentMetadataConfigurationUpdates()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        case "UserTokenConfigurations":
            return Optional.ofNullable(clazz.cast(userTokenConfigurations()));
        case "UserContextPolicy":
            return Optional.ofNullable(clazz.cast(userContextPolicyAsString()));
        case "UserGroupResolutionConfiguration":
            return Optional.ofNullable(clazz.cast(userGroupResolutionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexRequest, T> g) {
        return obj -> g.apply((UpdateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIndexRequest> {
        /**
         * <p>
         * The identifier of the index you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of the index you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the index you want to update.
         * </p>
         * 
         * @param name
         *        The name of the index you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon CloudWatch
         * logs and metrics.
         * </p>
         * 
         * @param roleArn
         *        An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon
         *        CloudWatch logs and metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A new description for the index.
         * </p>
         * 
         * @param description
         *        A new description for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The document metadata configuration you want to update for the index. Document metadata are fields or
         * attributes associated with your documents. For example, the company department name associated with each
         * document.
         * </p>
         * 
         * @param documentMetadataConfigurationUpdates
         *        The document metadata configuration you want to update for the index. Document metadata are fields or
         *        attributes associated with your documents. For example, the company department name associated with
         *        each document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates);

        /**
         * <p>
         * The document metadata configuration you want to update for the index. Document metadata are fields or
         * attributes associated with your documents. For example, the company department name associated with each
         * document.
         * </p>
         * 
         * @param documentMetadataConfigurationUpdates
         *        The document metadata configuration you want to update for the index. Document metadata are fields or
         *        attributes associated with your documents. For example, the company department name associated with
         *        each document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurationUpdates(DocumentMetadataConfiguration... documentMetadataConfigurationUpdates);

        /**
         * <p>
         * The document metadata configuration you want to update for the index. Document metadata are fields or
         * attributes associated with your documents. For example, the company department name associated with each
         * document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentMetadataConfigurationUpdates(List<DocumentMetadataConfiguration>)}.
         * 
         * @param documentMetadataConfigurationUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadataConfigurationUpdates(java.util.Collection<DocumentMetadataConfiguration>)
         */
        Builder documentMetadataConfigurationUpdates(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurationUpdates);

        /**
         * <p>
         * Sets the number of additional document storage and query capacity units that should be used by the index. You
         * can change the capacity of the index up to 5 times per day, or make 5 API calls.
         * </p>
         * <p>
         * If you are using extra storage units, you can't reduce the storage capacity below what is required to meet
         * the storage needs for your index.
         * </p>
         * 
         * @param capacityUnits
         *        Sets the number of additional document storage and query capacity units that should be used by the
         *        index. You can change the capacity of the index up to 5 times per day, or make 5 API calls.</p>
         *        <p>
         *        If you are using extra storage units, you can't reduce the storage capacity below what is required to
         *        meet the storage needs for your index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(CapacityUnitsConfiguration capacityUnits);

        /**
         * <p>
         * Sets the number of additional document storage and query capacity units that should be used by the index. You
         * can change the capacity of the index up to 5 times per day, or make 5 API calls.
         * </p>
         * <p>
         * If you are using extra storage units, you can't reduce the storage capacity below what is required to meet
         * the storage needs for your index.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUnitsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityUnitsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityUnitsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityUnits(CapacityUnitsConfiguration)}.
         * 
         * @param capacityUnits
         *        a consumer that will call methods on {@link CapacityUnitsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityUnits(CapacityUnitsConfiguration)
         */
        default Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return capacityUnits(CapacityUnitsConfiguration.builder().applyMutation(capacityUnits).build());
        }

        /**
         * <p>
         * The user token configuration.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations);

        /**
         * <p>
         * The user token configuration.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations);

        /**
         * <p>
         * The user token configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.UserTokenConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kendra.model.UserTokenConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.UserTokenConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #userTokenConfigurations(List<UserTokenConfiguration>)}.
         * 
         * @param userTokenConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.UserTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userTokenConfigurations(java.util.Collection<UserTokenConfiguration>)
         */
        Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations);

        /**
         * <p>
         * The user context policy.
         * </p>
         * 
         * @param userContextPolicy
         *        The user context policy.
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(String userContextPolicy);

        /**
         * <p>
         * The user context policy.
         * </p>
         * 
         * @param userContextPolicy
         *        The user context policy.
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(UserContextPolicy userContextPolicy);

        /**
         * <p>
         * Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On)
         * identity source. To configure this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         * >UserGroupResolutionConfiguration</a>.
         * </p>
         * 
         * @param userGroupResolutionConfiguration
         *        Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single
         *        Sign-On) identity source. To configure this, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         *        >UserGroupResolutionConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration);

        /**
         * <p>
         * Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On)
         * identity source. To configure this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         * >UserGroupResolutionConfiguration</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserGroupResolutionConfiguration.Builder}
         * avoiding the need to create one manually via {@link UserGroupResolutionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserGroupResolutionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)}.
         * 
         * @param userGroupResolutionConfiguration
         *        a consumer that will call methods on {@link UserGroupResolutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)
         */
        default Builder userGroupResolutionConfiguration(
                Consumer<UserGroupResolutionConfiguration.Builder> userGroupResolutionConfiguration) {
            return userGroupResolutionConfiguration(UserGroupResolutionConfiguration.builder()
                    .applyMutation(userGroupResolutionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String roleArn;

        private String description;

        private List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates = DefaultSdkAutoConstructList
                .getInstance();

        private CapacityUnitsConfiguration capacityUnits;

        private List<UserTokenConfiguration> userTokenConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String userContextPolicy;

        private UserGroupResolutionConfiguration userGroupResolutionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            roleArn(model.roleArn);
            description(model.description);
            documentMetadataConfigurationUpdates(model.documentMetadataConfigurationUpdates);
            capacityUnits(model.capacityUnits);
            userTokenConfigurations(model.userTokenConfigurations);
            userContextPolicy(model.userContextPolicy);
            userGroupResolutionConfiguration(model.userGroupResolutionConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurationUpdates() {
            List<DocumentMetadataConfiguration.Builder> result = DocumentMetadataConfigurationListCopier
                    .copyToBuilder(this.documentMetadataConfigurationUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier
                    .copyFromBuilder(documentMetadataConfigurationUpdates);
        }

        @Override
        public final Builder documentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier
                    .copy(documentMetadataConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(
                DocumentMetadataConfiguration... documentMetadataConfigurationUpdates) {
            documentMetadataConfigurationUpdates(Arrays.asList(documentMetadataConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurationUpdates) {
            documentMetadataConfigurationUpdates(Stream.of(documentMetadataConfigurationUpdates)
                    .map(c -> DocumentMetadataConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return capacityUnits != null ? capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final List<UserTokenConfiguration.Builder> getUserTokenConfigurations() {
            List<UserTokenConfiguration.Builder> result = UserTokenConfigurationListCopier
                    .copyToBuilder(this.userTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserTokenConfigurations(Collection<UserTokenConfiguration.BuilderImpl> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copyFromBuilder(userTokenConfigurations);
        }

        @Override
        public final Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copy(userTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations) {
            userTokenConfigurations(Arrays.asList(userTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations) {
            userTokenConfigurations(Stream.of(userTokenConfigurations)
                    .map(c -> UserTokenConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserContextPolicy() {
            return userContextPolicy;
        }

        public final void setUserContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
        }

        @Override
        public final Builder userContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        @Override
        public final Builder userContextPolicy(UserContextPolicy userContextPolicy) {
            this.userContextPolicy(userContextPolicy == null ? null : userContextPolicy.toString());
            return this;
        }

        public final UserGroupResolutionConfiguration.Builder getUserGroupResolutionConfiguration() {
            return userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration.toBuilder() : null;
        }

        public final void setUserGroupResolutionConfiguration(
                UserGroupResolutionConfiguration.BuilderImpl userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexRequest build() {
            return new UpdateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
