/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;

public class ListExperiencesIterable
implements SdkIterable<ListExperiencesResponse> {
    private final KendraClient client;
    private final ListExperiencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExperiencesIterable(KendraClient client, ListExperiencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExperiencesResponseFetcher();
    }

    public Iterator<ListExperiencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExperiencesResponseFetcher
    implements SyncPageFetcher<ListExperiencesResponse> {
        private ListExperiencesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperiencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExperiencesResponse nextPage(ListExperiencesResponse previousPage) {
            if (previousPage == null) {
                return ListExperiencesIterable.this.client.listExperiences(ListExperiencesIterable.this.firstRequest);
            }
            return ListExperiencesIterable.this.client.listExperiences((ListExperiencesRequest)((Object)ListExperiencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

