/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.KeyLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JwtTokenTypeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JwtTokenTypeConfiguration> {
    private static final SdkField<String> KEY_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyLocation").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::keyLocationAsString)).setter(JwtTokenTypeConfiguration.setter(Builder::keyLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLocation").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("URL").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::url)).setter(JwtTokenTypeConfiguration.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URL").build()}).build();
    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretManagerArn").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::secretManagerArn)).setter(JwtTokenTypeConfiguration.setter(Builder::secretManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()}).build();
    private static final SdkField<String> USER_NAME_ATTRIBUTE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserNameAttributeField").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::userNameAttributeField)).setter(JwtTokenTypeConfiguration.setter(Builder::userNameAttributeField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNameAttributeField").build()}).build();
    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupAttributeField").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::groupAttributeField)).setter(JwtTokenTypeConfiguration.setter(Builder::groupAttributeField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupAttributeField").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::issuer)).setter(JwtTokenTypeConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> CLAIM_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClaimRegex").getter(JwtTokenTypeConfiguration.getter(JwtTokenTypeConfiguration::claimRegex)).setter(JwtTokenTypeConfiguration.setter(Builder::claimRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimRegex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_LOCATION_FIELD, URL_FIELD, SECRET_MANAGER_ARN_FIELD, USER_NAME_ATTRIBUTE_FIELD_FIELD, GROUP_ATTRIBUTE_FIELD_FIELD, ISSUER_FIELD, CLAIM_REGEX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyLocation;
    private final String url;
    private final String secretManagerArn;
    private final String userNameAttributeField;
    private final String groupAttributeField;
    private final String issuer;
    private final String claimRegex;

    private JwtTokenTypeConfiguration(BuilderImpl builder) {
        this.keyLocation = builder.keyLocation;
        this.url = builder.url;
        this.secretManagerArn = builder.secretManagerArn;
        this.userNameAttributeField = builder.userNameAttributeField;
        this.groupAttributeField = builder.groupAttributeField;
        this.issuer = builder.issuer;
        this.claimRegex = builder.claimRegex;
    }

    public final KeyLocation keyLocation() {
        return KeyLocation.fromValue(this.keyLocation);
    }

    public final String keyLocationAsString() {
        return this.keyLocation;
    }

    public final String url() {
        return this.url;
    }

    public final String secretManagerArn() {
        return this.secretManagerArn;
    }

    public final String userNameAttributeField() {
        return this.userNameAttributeField;
    }

    public final String groupAttributeField() {
        return this.groupAttributeField;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String claimRegex() {
        return this.claimRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyLocationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userNameAttributeField());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAttributeField());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimRegex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtTokenTypeConfiguration)) {
            return false;
        }
        JwtTokenTypeConfiguration other = (JwtTokenTypeConfiguration)obj;
        return Objects.equals(this.keyLocationAsString(), other.keyLocationAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.secretManagerArn(), other.secretManagerArn()) && Objects.equals(this.userNameAttributeField(), other.userNameAttributeField()) && Objects.equals(this.groupAttributeField(), other.groupAttributeField()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.claimRegex(), other.claimRegex());
    }

    public final String toString() {
        return ToString.builder((String)"JwtTokenTypeConfiguration").add("KeyLocation", (Object)this.keyLocationAsString()).add("URL", (Object)this.url()).add("SecretManagerArn", (Object)this.secretManagerArn()).add("UserNameAttributeField", (Object)this.userNameAttributeField()).add("GroupAttributeField", (Object)this.groupAttributeField()).add("Issuer", (Object)this.issuer()).add("ClaimRegex", (Object)this.claimRegex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyLocation": {
                return Optional.ofNullable(clazz.cast(this.keyLocationAsString()));
            }
            case "URL": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "SecretManagerArn": {
                return Optional.ofNullable(clazz.cast(this.secretManagerArn()));
            }
            case "UserNameAttributeField": {
                return Optional.ofNullable(clazz.cast(this.userNameAttributeField()));
            }
            case "GroupAttributeField": {
                return Optional.ofNullable(clazz.cast(this.groupAttributeField()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "ClaimRegex": {
                return Optional.ofNullable(clazz.cast(this.claimRegex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JwtTokenTypeConfiguration, T> g) {
        return obj -> g.apply((JwtTokenTypeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyLocation;
        private String url;
        private String secretManagerArn;
        private String userNameAttributeField;
        private String groupAttributeField;
        private String issuer;
        private String claimRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(JwtTokenTypeConfiguration model) {
            this.keyLocation(model.keyLocation);
            this.url(model.url);
            this.secretManagerArn(model.secretManagerArn);
            this.userNameAttributeField(model.userNameAttributeField);
            this.groupAttributeField(model.groupAttributeField);
            this.issuer(model.issuer);
            this.claimRegex(model.claimRegex);
        }

        public final String getKeyLocation() {
            return this.keyLocation;
        }

        public final void setKeyLocation(String keyLocation) {
            this.keyLocation = keyLocation;
        }

        @Override
        public final Builder keyLocation(String keyLocation) {
            this.keyLocation = keyLocation;
            return this;
        }

        @Override
        public final Builder keyLocation(KeyLocation keyLocation) {
            this.keyLocation(keyLocation == null ? null : keyLocation.toString());
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getSecretManagerArn() {
            return this.secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final String getUserNameAttributeField() {
            return this.userNameAttributeField;
        }

        public final void setUserNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
        }

        @Override
        public final Builder userNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
            return this;
        }

        public final String getGroupAttributeField() {
            return this.groupAttributeField;
        }

        public final void setGroupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
        }

        @Override
        public final Builder groupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getClaimRegex() {
            return this.claimRegex;
        }

        public final void setClaimRegex(String claimRegex) {
            this.claimRegex = claimRegex;
        }

        @Override
        public final Builder claimRegex(String claimRegex) {
            this.claimRegex = claimRegex;
            return this;
        }

        public JwtTokenTypeConfiguration build() {
            return new JwtTokenTypeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JwtTokenTypeConfiguration> {
        public Builder keyLocation(String var1);

        public Builder keyLocation(KeyLocation var1);

        public Builder url(String var1);

        public Builder secretManagerArn(String var1);

        public Builder userNameAttributeField(String var1);

        public Builder groupAttributeField(String var1);

        public Builder issuer(String var1);

        public Builder claimRegex(String var1);
    }
}

