/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePrincipalMappingRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, DescribePrincipalMappingRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(DescribePrincipalMappingRequest.getter(DescribePrincipalMappingRequest::indexId)).setter(DescribePrincipalMappingRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(DescribePrincipalMappingRequest.getter(DescribePrincipalMappingRequest::dataSourceId)).setter(DescribePrincipalMappingRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DescribePrincipalMappingRequest.getter(DescribePrincipalMappingRequest::groupId)).setter(DescribePrincipalMappingRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD));
    private final String indexId;
    private final String dataSourceId;
    private final String groupId;

    private DescribePrincipalMappingRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String groupId() {
        return this.groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalMappingRequest)) {
            return false;
        }
        DescribePrincipalMappingRequest other = (DescribePrincipalMappingRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.groupId(), other.groupId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePrincipalMappingRequest").add("IndexId", (Object)this.indexId()).add("DataSourceId", (Object)this.dataSourceId()).add("GroupId", (Object)this.groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePrincipalMappingRequest, T> g) {
        return obj -> g.apply((DescribePrincipalMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String dataSourceId;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalMappingRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.dataSourceId(model.dataSourceId);
            this.groupId(model.groupId);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePrincipalMappingRequest build() {
            return new DescribePrincipalMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePrincipalMappingRequest> {
        public Builder indexId(String var1);

        public Builder dataSourceId(String var1);

        public Builder groupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

