/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceSyncJobMetricTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceSyncJobMetricTarget> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(DataSourceSyncJobMetricTarget.getter(DataSourceSyncJobMetricTarget::dataSourceId)).setter(DataSourceSyncJobMetricTarget.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_SYNC_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceSyncJobId").getter(DataSourceSyncJobMetricTarget.getter(DataSourceSyncJobMetricTarget::dataSourceSyncJobId)).setter(DataSourceSyncJobMetricTarget.setter(Builder::dataSourceSyncJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceSyncJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, DATA_SOURCE_SYNC_JOB_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSourceId;
    private final String dataSourceSyncJobId;

    private DataSourceSyncJobMetricTarget(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceSyncJobId = builder.dataSourceSyncJobId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String dataSourceSyncJobId() {
        return this.dataSourceSyncJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceSyncJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJobMetricTarget)) {
            return false;
        }
        DataSourceSyncJobMetricTarget other = (DataSourceSyncJobMetricTarget)obj;
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceSyncJobId(), other.dataSourceSyncJobId());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceSyncJobMetricTarget").add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceSyncJobId", (Object)this.dataSourceSyncJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceSyncJobId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceSyncJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJobMetricTarget, T> g) {
        return obj -> g.apply((DataSourceSyncJobMetricTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceSyncJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJobMetricTarget model) {
            this.dataSourceId(model.dataSourceId);
            this.dataSourceSyncJobId(model.dataSourceSyncJobId);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        @Transient
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceSyncJobId() {
            return this.dataSourceSyncJobId;
        }

        public final void setDataSourceSyncJobId(String dataSourceSyncJobId) {
            this.dataSourceSyncJobId = dataSourceSyncJobId;
        }

        @Override
        @Transient
        public final Builder dataSourceSyncJobId(String dataSourceSyncJobId) {
            this.dataSourceSyncJobId = dataSourceSyncJobId;
            return this;
        }

        public DataSourceSyncJobMetricTarget build() {
            return new DataSourceSyncJobMetricTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceSyncJobMetricTarget> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceSyncJobId(String var1);
    }
}

