/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateDataSourceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(UpdateDataSourceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<DataSourceConfiguration> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateDataSourceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(UpdateDataSourceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(UpdateDataSourceRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateDataSourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(UpdateDataSourceRequest::languageCode))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<CustomDocumentEnrichmentConfiguration> CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<CustomDocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDocumentEnrichmentConfiguration")
            .getter(getter(UpdateDataSourceRequest::customDocumentEnrichmentConfiguration))
            .setter(setter(Builder::customDocumentEnrichmentConfiguration))
            .constructor(CustomDocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomDocumentEnrichmentConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            INDEX_ID_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, DESCRIPTION_FIELD, SCHEDULE_FIELD, ROLE_ARN_FIELD,
            LANGUAGE_CODE_FIELD, CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD));

    private final String id;

    private final String name;

    private final String indexId;

    private final DataSourceConfiguration configuration;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final String description;

    private final String schedule;

    private final String roleArn;

    private final String languageCode;

    private final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.indexId = builder.indexId;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.roleArn = builder.roleArn;
        this.languageCode = builder.languageCode;
        this.customDocumentEnrichmentConfiguration = builder.customDocumentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The identifier of the data source connector you want to update.
     * </p>
     * 
     * @return The identifier of the data source connector you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A new name for the data source connector.
     * </p>
     * 
     * @return A new name for the data source connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the index used with the data source connector.
     * </p>
     * 
     * @return The identifier of the index used with the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * Configuration information you want to update for the data source connector.
     * </p>
     * 
     * @return Configuration information you want to update for the data source connector.
     */
    public final DataSourceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
     * VPC</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * A new description for the data source connector.
     * </p>
     * 
     * @return A new description for the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The sync schedule you want to update for the data source connector.
     * </p>
     * 
     * @return The sync schedule you want to update for the data source connector.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source and required resources. For
     * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon
     * Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source and required
     *         resources. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The code for a language you want to update for the data source connector. This allows you to support a language
     * for all documents when updating the data source. English is supported by default. For more information on
     * supported languages, including their codes, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other
     * than English</a>.
     * </p>
     * 
     * @return The code for a language you want to update for the data source connector. This allows you to support a
     *         language for all documents when updating the data source. English is supported by default. For more
     *         information on supported languages, including their codes, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
     *         languages other than English</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * <p>
     * Configuration information you want to update for altering document metadata and content during the document
     * ingestion process.
     * </p>
     * <p>
     * For more information on how to create, modify and delete document metadata, or make other content alterations
     * when you ingest documents into Amazon Kendra, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata
     * during the ingestion process</a>.
     * </p>
     * 
     * @return Configuration information you want to update for altering document metadata and content during the
     *         document ingestion process.</p>
     *         <p>
     *         For more information on how to create, modify and delete document metadata, or make other content
     *         alterations when you ingest documents into Amazon Kendra, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
     *         metadata during the ingestion process</a>.
     */
    public final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration() {
        return customDocumentEnrichmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(customDocumentEnrichmentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(indexId(), other.indexId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(customDocumentEnrichmentConfiguration(), other.customDocumentEnrichmentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourceRequest").add("Id", id()).add("Name", name()).add("IndexId", indexId())
                .add("Configuration", configuration()).add("VpcConfiguration", vpcConfiguration())
                .add("Description", description()).add("Schedule", schedule()).add("RoleArn", roleArn())
                .add("LanguageCode", languageCode())
                .add("CustomDocumentEnrichmentConfiguration", customDocumentEnrichmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "CustomDocumentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(customDocumentEnrichmentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The identifier of the data source connector you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of the data source connector you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A new name for the data source connector.
         * </p>
         * 
         * @param name
         *        A new name for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the index used with the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index used with the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Configuration information you want to update for the data source connector.
         * </p>
         * 
         * @param configuration
         *        Configuration information you want to update for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfiguration configuration);

        /**
         * <p>
         * Configuration information you want to update for the data source connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(DataSourceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfiguration)
         */
        default Builder configuration(Consumer<DataSourceConfiguration.Builder> configuration) {
            return configuration(DataSourceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
         * VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
         * VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * A new description for the data source connector.
         * </p>
         * 
         * @param description
         *        A new description for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The sync schedule you want to update for the data source connector.
         * </p>
         * 
         * @param schedule
         *        The sync schedule you want to update for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source and required resources.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for
         * Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source and required
         *        resources. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The code for a language you want to update for the data source connector. This allows you to support a
         * language for all documents when updating the data source. English is supported by default. For more
         * information on supported languages, including their codes, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
         * other than English</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for a language you want to update for the data source connector. This allows you to support a
         *        language for all documents when updating the data source. English is supported by default. For more
         *        information on supported languages, including their codes, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
         *        languages other than English</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Configuration information you want to update for altering document metadata and content during the document
         * ingestion process.
         * </p>
         * <p>
         * For more information on how to create, modify and delete document metadata, or make other content alterations
         * when you ingest documents into Amazon Kendra, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
         * metadata during the ingestion process</a>.
         * </p>
         * 
         * @param customDocumentEnrichmentConfiguration
         *        Configuration information you want to update for altering document metadata and content during the
         *        document ingestion process.</p>
         *        <p>
         *        For more information on how to create, modify and delete document metadata, or make other content
         *        alterations when you ingest documents into Amazon Kendra, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
         *        document metadata during the ingestion process</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration);

        /**
         * <p>
         * Configuration information you want to update for altering document metadata and content during the document
         * ingestion process.
         * </p>
         * <p>
         * For more information on how to create, modify and delete document metadata, or make other content alterations
         * when you ingest documents into Amazon Kendra, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
         * metadata during the ingestion process</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomDocumentEnrichmentConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomDocumentEnrichmentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration)}.
         * 
         * @param customDocumentEnrichmentConfiguration
         *        a consumer that will call methods on {@link CustomDocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration)
         */
        default Builder customDocumentEnrichmentConfiguration(
                Consumer<CustomDocumentEnrichmentConfiguration.Builder> customDocumentEnrichmentConfiguration) {
            return customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration.builder()
                    .applyMutation(customDocumentEnrichmentConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String indexId;

        private DataSourceConfiguration configuration;

        private DataSourceVpcConfiguration vpcConfiguration;

        private String description;

        private String schedule;

        private String roleArn;

        private String languageCode;

        private CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            indexId(model.indexId);
            configuration(model.configuration);
            vpcConfiguration(model.vpcConfiguration);
            description(model.description);
            schedule(model.schedule);
            roleArn(model.roleArn);
            languageCode(model.languageCode);
            customDocumentEnrichmentConfiguration(model.customDocumentEnrichmentConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final DataSourceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final CustomDocumentEnrichmentConfiguration.Builder getCustomDocumentEnrichmentConfiguration() {
            return customDocumentEnrichmentConfiguration != null ? customDocumentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setCustomDocumentEnrichmentConfiguration(
                CustomDocumentEnrichmentConfiguration.BuilderImpl customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration != null ? customDocumentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder customDocumentEnrichmentConfiguration(
                CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
