/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.SiteMapsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SiteMapsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SiteMapsConfiguration> {
    private static final SdkField<List<String>> SITE_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SiteMaps").getter(SiteMapsConfiguration.getter(SiteMapsConfiguration::siteMaps)).setter(SiteMapsConfiguration.setter(Builder::siteMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_MAPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> siteMaps;

    private SiteMapsConfiguration(BuilderImpl builder) {
        this.siteMaps = builder.siteMaps;
    }

    public final boolean hasSiteMaps() {
        return this.siteMaps != null && !(this.siteMaps instanceof SdkAutoConstructList);
    }

    public final List<String> siteMaps() {
        return this.siteMaps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSiteMaps() ? this.siteMaps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SiteMapsConfiguration)) {
            return false;
        }
        SiteMapsConfiguration other = (SiteMapsConfiguration)obj;
        return this.hasSiteMaps() == other.hasSiteMaps() && Objects.equals(this.siteMaps(), other.siteMaps());
    }

    public final String toString() {
        return ToString.builder((String)"SiteMapsConfiguration").add("SiteMaps", this.hasSiteMaps() ? this.siteMaps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SiteMaps": {
                return Optional.ofNullable(clazz.cast(this.siteMaps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SiteMapsConfiguration, T> g) {
        return obj -> g.apply((SiteMapsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> siteMaps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SiteMapsConfiguration model) {
            this.siteMaps(model.siteMaps);
        }

        public final Collection<String> getSiteMaps() {
            if (this.siteMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.siteMaps;
        }

        @Override
        public final Builder siteMaps(Collection<String> siteMaps) {
            this.siteMaps = SiteMapsListCopier.copy(siteMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder siteMaps(String ... siteMaps) {
            this.siteMaps(Arrays.asList(siteMaps));
            return this;
        }

        public final void setSiteMaps(Collection<String> siteMaps) {
            this.siteMaps = SiteMapsListCopier.copy(siteMaps);
        }

        public SiteMapsConfiguration build() {
            return new SiteMapsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SiteMapsConfiguration> {
        public Builder siteMaps(Collection<String> var1);

        public Builder siteMaps(String ... var1);
    }
}

