/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.Highlight;
import software.amazon.awssdk.services.kendra.model.HighlightListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextWithHighlights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextWithHighlights> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(TextWithHighlights.getter(TextWithHighlights::text)).setter(TextWithHighlights.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<Highlight>> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Highlights").getter(TextWithHighlights.getter(TextWithHighlights::highlights)).setter(TextWithHighlights.setter(Builder::highlights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, HIGHLIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final List<Highlight> highlights;

    private TextWithHighlights(BuilderImpl builder) {
        this.text = builder.text;
        this.highlights = builder.highlights;
    }

    public final String text() {
        return this.text;
    }

    public final boolean hasHighlights() {
        return this.highlights != null && !(this.highlights instanceof SdkAutoConstructList);
    }

    public final List<Highlight> highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHighlights() ? this.highlights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextWithHighlights)) {
            return false;
        }
        TextWithHighlights other = (TextWithHighlights)obj;
        return Objects.equals(this.text(), other.text()) && this.hasHighlights() == other.hasHighlights() && Objects.equals(this.highlights(), other.highlights());
    }

    public final String toString() {
        return ToString.builder((String)"TextWithHighlights").add("Text", (Object)this.text()).add("Highlights", this.hasHighlights() ? this.highlights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextWithHighlights, T> g) {
        return obj -> g.apply((TextWithHighlights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private List<Highlight> highlights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TextWithHighlights model) {
            this.text(model.text);
            this.highlights(model.highlights);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Collection<Highlight.Builder> getHighlights() {
            if (this.highlights instanceof SdkAutoConstructList) {
                return null;
            }
            return this.highlights != null ? (Collection)this.highlights.stream().map(Highlight::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder highlights(Collection<Highlight> highlights) {
            this.highlights = HighlightListCopier.copy(highlights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Highlight ... highlights) {
            this.highlights(Arrays.asList(highlights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Consumer<Highlight.Builder> ... highlights) {
            this.highlights(Stream.of(highlights).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHighlights(Collection<Highlight.BuilderImpl> highlights) {
            this.highlights = HighlightListCopier.copyFromBuilder(highlights);
        }

        public TextWithHighlights build() {
            return new TextWithHighlights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextWithHighlights> {
        public Builder text(String var1);

        public Builder highlights(Collection<Highlight> var1);

        public Builder highlights(Highlight ... var1);

        public Builder highlights(Consumer<Highlight.Builder> ... var1);
    }
}

