/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentFieldMappingsListCopier;
import software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfluenceAttachmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfluenceAttachmentConfiguration> {
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlAttachments").getter(ConfluenceAttachmentConfiguration.getter(ConfluenceAttachmentConfiguration::crawlAttachments)).setter(ConfluenceAttachmentConfiguration.setter(Builder::crawlAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()}).build();
    private static final SdkField<List<ConfluenceAttachmentToIndexFieldMapping>> ATTACHMENT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentFieldMappings").getter(ConfluenceAttachmentConfiguration.getter(ConfluenceAttachmentConfiguration::attachmentFieldMappings)).setter(ConfluenceAttachmentConfiguration.setter(Builder::attachmentFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfluenceAttachmentToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ATTACHMENTS_FIELD, ATTACHMENT_FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean crawlAttachments;
    private final List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings;

    private ConfluenceAttachmentConfiguration(BuilderImpl builder) {
        this.crawlAttachments = builder.crawlAttachments;
        this.attachmentFieldMappings = builder.attachmentFieldMappings;
    }

    public Boolean crawlAttachments() {
        return this.crawlAttachments;
    }

    public boolean hasAttachmentFieldMappings() {
        return this.attachmentFieldMappings != null && !(this.attachmentFieldMappings instanceof SdkAutoConstructList);
    }

    public List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings() {
        return this.attachmentFieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentFieldMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceAttachmentConfiguration)) {
            return false;
        }
        ConfluenceAttachmentConfiguration other = (ConfluenceAttachmentConfiguration)obj;
        return Objects.equals(this.crawlAttachments(), other.crawlAttachments()) && Objects.equals(this.attachmentFieldMappings(), other.attachmentFieldMappings());
    }

    public String toString() {
        return ToString.builder((String)"ConfluenceAttachmentConfiguration").add("CrawlAttachments", (Object)this.crawlAttachments()).add("AttachmentFieldMappings", this.attachmentFieldMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlAttachments": {
                return Optional.ofNullable(clazz.cast(this.crawlAttachments()));
            }
            case "AttachmentFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.attachmentFieldMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceAttachmentConfiguration, T> g) {
        return obj -> g.apply((ConfluenceAttachmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean crawlAttachments;
        private List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceAttachmentConfiguration model) {
            this.crawlAttachments(model.crawlAttachments);
            this.attachmentFieldMappings(model.attachmentFieldMappings);
        }

        public final Boolean getCrawlAttachments() {
            return this.crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final Collection<ConfluenceAttachmentToIndexFieldMapping.Builder> getAttachmentFieldMappings() {
            return this.attachmentFieldMappings != null ? (Collection)this.attachmentFieldMappings.stream().map(ConfluenceAttachmentToIndexFieldMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentFieldMappings(Collection<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings) {
            this.attachmentFieldMappings = ConfluenceAttachmentFieldMappingsListCopier.copy(attachmentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(ConfluenceAttachmentToIndexFieldMapping ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Arrays.asList(attachmentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(Consumer<ConfluenceAttachmentToIndexFieldMapping.Builder> ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Stream.of(attachmentFieldMappings).map(c -> (ConfluenceAttachmentToIndexFieldMapping)((ConfluenceAttachmentToIndexFieldMapping.Builder)ConfluenceAttachmentToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentFieldMappings(Collection<ConfluenceAttachmentToIndexFieldMapping.BuilderImpl> attachmentFieldMappings) {
            this.attachmentFieldMappings = ConfluenceAttachmentFieldMappingsListCopier.copyFromBuilder(attachmentFieldMappings);
        }

        public ConfluenceAttachmentConfiguration build() {
            return new ConfluenceAttachmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfluenceAttachmentConfiguration> {
        public Builder crawlAttachments(Boolean var1);

        public Builder attachmentFieldMappings(Collection<ConfluenceAttachmentToIndexFieldMapping> var1);

        public Builder attachmentFieldMappings(ConfluenceAttachmentToIndexFieldMapping ... var1);

        public Builder attachmentFieldMappings(Consumer<ConfluenceAttachmentToIndexFieldMapping.Builder> ... var1);
    }
}

