/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kafkaconnect.DefaultKafkaConnectBaseClientBuilder;
import software.amazon.awssdk.services.kafkaconnect.DefaultKafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClientBuilder;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.kafkaconnect.endpoints.KafkaConnectEndpointProvider;

@SdkInternalApi
final class DefaultKafkaConnectClientBuilder
extends DefaultKafkaConnectBaseClientBuilder<KafkaConnectClientBuilder, KafkaConnectClient>
implements KafkaConnectClientBuilder {
    DefaultKafkaConnectClientBuilder() {
    }

    @Override
    public DefaultKafkaConnectClientBuilder endpointProvider(KafkaConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KafkaConnectClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKafkaConnectClientBuilder.validateClientOptions(clientConfiguration);
        KafkaConnectServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKafkaConnectClient client = new DefaultKafkaConnectClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KafkaConnectServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KafkaConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

