/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerConfigurationRevisionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerConfigurationRevisionDescription> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(WorkerConfigurationRevisionDescription.getter(WorkerConfigurationRevisionDescription::creationTime)).setter(WorkerConfigurationRevisionDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkerConfigurationRevisionDescription.getter(WorkerConfigurationRevisionDescription::description)).setter(WorkerConfigurationRevisionDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PROPERTIES_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertiesFileContent").getter(WorkerConfigurationRevisionDescription.getter(WorkerConfigurationRevisionDescription::propertiesFileContent)).setter(WorkerConfigurationRevisionDescription.setter(Builder::propertiesFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertiesFileContent").build()}).build();
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("revision").getter(WorkerConfigurationRevisionDescription.getter(WorkerConfigurationRevisionDescription::revision)).setter(WorkerConfigurationRevisionDescription.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DESCRIPTION_FIELD, PROPERTIES_FILE_CONTENT_FIELD, REVISION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String description;
    private final String propertiesFileContent;
    private final Long revision;

    private WorkerConfigurationRevisionDescription(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.propertiesFileContent = builder.propertiesFileContent;
        this.revision = builder.revision;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String propertiesFileContent() {
        return this.propertiesFileContent;
    }

    public final Long revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertiesFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerConfigurationRevisionDescription)) {
            return false;
        }
        WorkerConfigurationRevisionDescription other = (WorkerConfigurationRevisionDescription)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.propertiesFileContent(), other.propertiesFileContent()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerConfigurationRevisionDescription").add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("PropertiesFileContent", (Object)(this.propertiesFileContent() == null ? null : "*** Sensitive Data Redacted ***")).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertiesFileContent": {
                return Optional.ofNullable(clazz.cast(this.propertiesFileContent()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerConfigurationRevisionDescription, T> g) {
        return obj -> g.apply((WorkerConfigurationRevisionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String description;
        private String propertiesFileContent;
        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerConfigurationRevisionDescription model) {
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.propertiesFileContent(model.propertiesFileContent);
            this.revision(model.revision);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPropertiesFileContent() {
            return this.propertiesFileContent;
        }

        public final void setPropertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
        }

        @Override
        @Transient
        public final Builder propertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
            return this;
        }

        public final Long getRevision() {
            return this.revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        @Transient
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public WorkerConfigurationRevisionDescription build() {
            return new WorkerConfigurationRevisionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerConfigurationRevisionDescription> {
        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder propertiesFileContent(String var1);

        public Builder revision(Long var1);
    }
}

