/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes all client authentication information.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessClientAuthentication.Builder, ServerlessClientAuthentication> {
    private static final SdkField<ServerlessSasl> SASL_FIELD = SdkField.<ServerlessSasl> builder(MarshallingType.SDK_POJO)
            .memberName("Sasl").getter(getter(ServerlessClientAuthentication::sasl)).setter(setter(Builder::sasl))
            .constructor(ServerlessSasl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sasl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServerlessSasl sasl;

    private ServerlessClientAuthentication(BuilderImpl builder) {
        this.sasl = builder.sasl;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using SASL.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using SASL.
     *         </p>
     */
    public final ServerlessSasl sasl() {
        return sasl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sasl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessClientAuthentication)) {
            return false;
        }
        ServerlessClientAuthentication other = (ServerlessClientAuthentication) obj;
        return Objects.equals(sasl(), other.sasl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessClientAuthentication").add("Sasl", sasl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sasl":
            return Optional.ofNullable(clazz.cast(sasl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sasl", SASL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessClientAuthentication, T> g) {
        return obj -> g.apply((ServerlessClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessClientAuthentication> {
        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * @param sasl
         *        <p>
         *        Details for ClientAuthentication using SASL.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sasl(ServerlessSasl sasl);

        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ServerlessSasl.Builder} avoiding the need
         * to create one manually via {@link ServerlessSasl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessSasl.Builder#build()} is called immediately and its
         * result is passed to {@link #sasl(ServerlessSasl)}.
         * 
         * @param sasl
         *        a consumer that will call methods on {@link ServerlessSasl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sasl(ServerlessSasl)
         */
        default Builder sasl(Consumer<ServerlessSasl.Builder> sasl) {
            return sasl(ServerlessSasl.builder().applyMutation(sasl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServerlessSasl sasl;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessClientAuthentication model) {
            sasl(model.sasl);
        }

        public final ServerlessSasl.Builder getSasl() {
            return sasl != null ? sasl.toBuilder() : null;
        }

        public final void setSasl(ServerlessSasl.BuilderImpl sasl) {
            this.sasl = sasl != null ? sasl.build() : null;
        }

        @Override
        public final Builder sasl(ServerlessSasl sasl) {
            this.sasl = sasl;
            return this;
        }

        @Override
        public ServerlessClientAuthentication build() {
            return new ServerlessClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
