/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterPolicyResponse extends KafkaResponse implements
        ToCopyableBuilder<GetClusterPolicyResponse.Builder, GetClusterPolicyResponse> {
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(GetClusterPolicyResponse::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(GetClusterPolicyResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_VERSION_FIELD,
            POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String currentVersion;

    private final String policy;

    private GetClusterPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.currentVersion = builder.currentVersion;
        this.policy = builder.policy;
    }

    /**
     *
     * <p>
     * The version of cluster policy.
     * </p>
     * 
     * @return <p>
     *         The version of cluster policy.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * The cluster policy.
     * </p>
     * 
     * @return <p>
     *         The cluster policy.
     *         </p>
     */
    public final String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterPolicyResponse)) {
            return false;
        }
        GetClusterPolicyResponse other = (GetClusterPolicyResponse) obj;
        return Objects.equals(currentVersion(), other.currentVersion()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClusterPolicyResponse").add("CurrentVersion", currentVersion()).add("Policy", policy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterPolicyResponse, T> g) {
        return obj -> g.apply((GetClusterPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClusterPolicyResponse> {
        /**
         *
         * <p>
         * The version of cluster policy.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of cluster policy.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * The cluster policy.
         * </p>
         * 
         * @param policy
         *        <p>
         *        The cluster policy.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String currentVersion;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterPolicyResponse model) {
            super(model);
            currentVersion(model.currentVersion);
            policy(model.policy);
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetClusterPolicyResponse build() {
            return new GetClusterPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
