/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTopicResponse extends KafkaResponse implements
        ToCopyableBuilder<DescribeTopicResponse.Builder, DescribeTopicResponse> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(DescribeTopicResponse::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(DescribeTopicResponse::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicName").build()).build();

    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicationFactor").getter(getter(DescribeTopicResponse::replicationFactor))
            .setter(setter(Builder::replicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationFactor").build()).build();

    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionCount").getter(getter(DescribeTopicResponse::partitionCount))
            .setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionCount").build()).build();

    private static final SdkField<String> CONFIGS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Configs")
            .getter(getter(DescribeTopicResponse::configs)).setter(setter(Builder::configs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configs").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeTopicResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            TOPIC_NAME_FIELD, REPLICATION_FACTOR_FIELD, PARTITION_COUNT_FIELD, CONFIGS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String topicArn;

    private final String topicName;

    private final Integer replicationFactor;

    private final Integer partitionCount;

    private final String configs;

    private final String status;

    private DescribeTopicResponse(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.topicName = builder.topicName;
        this.replicationFactor = builder.replicationFactor;
        this.partitionCount = builder.partitionCount;
        this.configs = builder.configs;
        this.status = builder.status;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the topic.
     *         </p>
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     *
     * <p>
     * The Kafka topic name of the topic.
     * </p>
     * 
     * @return <p>
     *         The Kafka topic name of the topic.
     *         </p>
     */
    public final String topicName() {
        return topicName;
    }

    /**
     *
     * <p>
     * The replication factor of the topic.
     * </p>
     * 
     * @return <p>
     *         The replication factor of the topic.
     *         </p>
     */
    public final Integer replicationFactor() {
        return replicationFactor;
    }

    /**
     *
     * <p>
     * The partition count of the topic.
     * </p>
     * 
     * @return <p>
     *         The partition count of the topic.
     *         </p>
     */
    public final Integer partitionCount() {
        return partitionCount;
    }

    /**
     *
     * <p>
     * Topic configurations encoded as a Base64 string.
     * </p>
     * 
     * @return <p>
     *         Topic configurations encoded as a Base64 string.
     *         </p>
     */
    public final String configs() {
        return configs;
    }

    /**
     *
     * <p>
     * The status of the topic.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return <p>
     *         The status of the topic.
     *         </p>
     * @see TopicState
     */
    public final TopicState status() {
        return TopicState.fromValue(status);
    }

    /**
     *
     * <p>
     * The status of the topic.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return <p>
     *         The status of the topic.
     *         </p>
     * @see TopicState
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(configs());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTopicResponse)) {
            return false;
        }
        DescribeTopicResponse other = (DescribeTopicResponse) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(replicationFactor(), other.replicationFactor())
                && Objects.equals(partitionCount(), other.partitionCount()) && Objects.equals(configs(), other.configs())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTopicResponse").add("TopicArn", topicArn()).add("TopicName", topicName())
                .add("ReplicationFactor", replicationFactor()).add("PartitionCount", partitionCount()).add("Configs", configs())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "ReplicationFactor":
            return Optional.ofNullable(clazz.cast(replicationFactor()));
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "Configs":
            return Optional.ofNullable(clazz.cast(configs()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicArn", TOPIC_ARN_FIELD);
        map.put("topicName", TOPIC_NAME_FIELD);
        map.put("replicationFactor", REPLICATION_FACTOR_FIELD);
        map.put("partitionCount", PARTITION_COUNT_FIELD);
        map.put("configs", CONFIGS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTopicResponse, T> g) {
        return obj -> g.apply((DescribeTopicResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTopicResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param topicArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         *
         * <p>
         * The Kafka topic name of the topic.
         * </p>
         * 
         * @param topicName
         *        <p>
         *        The Kafka topic name of the topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         *
         * <p>
         * The replication factor of the topic.
         * </p>
         * 
         * @param replicationFactor
         *        <p>
         *        The replication factor of the topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationFactor(Integer replicationFactor);

        /**
         *
         * <p>
         * The partition count of the topic.
         * </p>
         * 
         * @param partitionCount
         *        <p>
         *        The partition count of the topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         *
         * <p>
         * Topic configurations encoded as a Base64 string.
         * </p>
         * 
         * @param configs
         *        <p>
         *        Topic configurations encoded as a Base64 string.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configs(String configs);

        /**
         *
         * <p>
         * The status of the topic.
         * </p>
         * 
         * @param status
         *        <p>
         *        The status of the topic.
         *        </p>
         * @see TopicState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicState
         */
        Builder status(String status);

        /**
         *
         * <p>
         * The status of the topic.
         * </p>
         * 
         * @param status
         *        <p>
         *        The status of the topic.
         *        </p>
         * @see TopicState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicState
         */
        Builder status(TopicState status);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String topicArn;

        private String topicName;

        private Integer replicationFactor;

        private Integer partitionCount;

        private String configs;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTopicResponse model) {
            super(model);
            topicArn(model.topicArn);
            topicName(model.topicName);
            replicationFactor(model.replicationFactor);
            partitionCount(model.partitionCount);
            configs(model.configs);
            status(model.status);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final Integer getReplicationFactor() {
            return replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final String getConfigs() {
            return configs;
        }

        public final void setConfigs(String configs) {
            this.configs = configs;
        }

        @Override
        public final Builder configs(String configs) {
            this.configs = configs;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeTopicResponse build() {
            return new DescribeTopicResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
