/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcConnectionResponse extends KafkaResponse implements
        ToCopyableBuilder<CreateVpcConnectionResponse.Builder, CreateVpcConnectionResponse> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(CreateVpcConnectionResponse::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateVpcConnectionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Authentication").getter(getter(CreateVpcConnectionResponse::authentication))
            .setter(setter(Builder::authentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateVpcConnectionResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientSubnets")
            .getter(getter(CreateVpcConnectionResponse::clientSubnets))
            .setter(setter(Builder::clientSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateVpcConnectionResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(CreateVpcConnectionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateVpcConnectionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD,
            STATE_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, CLIENT_SUBNETS_FIELD, SECURITY_GROUPS_FIELD, CREATION_TIME_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vpcConnectionArn;

    private final String state;

    private final String authentication;

    private final String vpcId;

    private final List<String> clientSubnets;

    private final List<String> securityGroups;

    private final Instant creationTime;

    private final Map<String, String> tags;

    private CreateVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.state = builder.state;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.clientSubnets = builder.clientSubnets;
        this.securityGroups = builder.securityGroups;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     *
     * <p>
     * The VPC connection ARN.
     * </p>
     * 
     * @return <p>
     *         The VPC connection ARN.
     *         </p>
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     *
     * <p>
     * The State of Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The State of Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(state);
    }

    /**
     *
     * <p>
     * The State of Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The State of Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     *
     * <p>
     * The authentication type of VPC connection.
     * </p>
     * 
     * @return <p>
     *         The authentication type of VPC connection.
     *         </p>
     */
    public final String authentication() {
        return authentication;
    }

    /**
     *
     * <p>
     * The VPC ID of the VPC connection.
     * </p>
     * 
     * @return <p>
     *         The VPC ID of the VPC connection.
     *         </p>
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientSubnets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientSubnets() {
        return clientSubnets != null && !(clientSubnets instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of client subnets.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientSubnets} method.
     * </p>
     * 
     * @return <p>
     *         The list of client subnets.
     *         </p>
     */
    public final List<String> clientSubnets() {
        return clientSubnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of security groups.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return <p>
     *         The list of security groups.
     *         </p>
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     *
     * <p>
     * The creation time of VPC connection.
     * </p>
     * 
     * @return <p>
     *         The creation time of VPC connection.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * A map of tags for the VPC connection.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         A map of tags for the VPC connection.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientSubnets() ? clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionResponse)) {
            return false;
        }
        CreateVpcConnectionResponse other = (CreateVpcConnectionResponse) obj;
        return Objects.equals(vpcConnectionArn(), other.vpcConnectionArn())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(vpcId(), other.vpcId())
                && hasClientSubnets() == other.hasClientSubnets() && Objects.equals(clientSubnets(), other.clientSubnets())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(creationTime(), other.creationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcConnectionResponse").add("VpcConnectionArn", vpcConnectionArn())
                .add("State", stateAsString()).add("Authentication", authentication()).add("VpcId", vpcId())
                .add("ClientSubnets", hasClientSubnets() ? clientSubnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ClientSubnets":
            return Optional.ofNullable(clazz.cast(clientSubnets()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("authentication", AUTHENTICATION_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("clientSubnets", CLIENT_SUBNETS_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectionResponse, T> g) {
        return obj -> g.apply((CreateVpcConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcConnectionResponse> {
        /**
         *
         * <p>
         * The VPC connection ARN.
         * </p>
         * 
         * @param vpcConnectionArn
         *        <p>
         *        The VPC connection ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         *
         * <p>
         * The State of Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        The State of Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The State of Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        The State of Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(VpcConnectionState state);

        /**
         *
         * <p>
         * The authentication type of VPC connection.
         * </p>
         * 
         * @param authentication
         *        <p>
         *        The authentication type of VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(String authentication);

        /**
         *
         * <p>
         * The VPC ID of the VPC connection.
         * </p>
         * 
         * @param vpcId
         *        <p>
         *        The VPC ID of the VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         *
         * <p>
         * The list of client subnets.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of client subnets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(Collection<String> clientSubnets);

        /**
         *
         * <p>
         * The list of client subnets.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of client subnets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(String... clientSubnets);

        /**
         *
         * <p>
         * The list of security groups.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The list of security groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         *
         * <p>
         * The list of security groups.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The list of security groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         *
         * <p>
         * The creation time of VPC connection.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The creation time of VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * A map of tags for the VPC connection.
         * </p>
         * 
         * @param tags
         *        <p>
         *        A map of tags for the VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String vpcConnectionArn;

        private String state;

        private String authentication;

        private String vpcId;

        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectionResponse model) {
            super(model);
            vpcConnectionArn(model.vpcConnectionArn);
            state(model.state);
            authentication(model.authentication);
            vpcId(model.vpcId);
            clientSubnets(model.clientSubnets);
            securityGroups(model.securityGroups);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAuthentication() {
            return authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getClientSubnets() {
            if (clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return clientSubnets;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String... clientSubnets) {
            clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public CreateVpcConnectionResponse build() {
            return new CreateVpcConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
