/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClusterOperationStep;
import software.amazon.awssdk.services.kafka.model.ErrorInfo;
import software.amazon.awssdk.services.kafka.model.MutableClusterInfo;
import software.amazon.awssdk.services.kafka.model.VpcConnectionInfo;
import software.amazon.awssdk.services.kafka.model.___listOfClusterOperationStepCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationInfo> {
    private static final SdkField<String> CLIENT_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestId").getter(ClusterOperationInfo.getter(ClusterOperationInfo::clientRequestId)).setter(ClusterOperationInfo.setter(Builder::clientRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestId").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterOperationInfo.getter(ClusterOperationInfo::clusterArn)).setter(ClusterOperationInfo.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClusterOperationInfo.getter(ClusterOperationInfo::creationTime)).setter(ClusterOperationInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ClusterOperationInfo.getter(ClusterOperationInfo::endTime)).setter(ClusterOperationInfo.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorInfo").getter(ClusterOperationInfo.getter(ClusterOperationInfo::errorInfo)).setter(ClusterOperationInfo.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationArn").getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationArn)).setter(ClusterOperationInfo.setter(Builder::operationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationState").getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationState)).setter(ClusterOperationInfo.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<List<ClusterOperationStep>> OPERATION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationSteps").getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationSteps)).setter(ClusterOperationInfo.setter(Builder::operationSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterOperationStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationType)).setter(ClusterOperationInfo.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<MutableClusterInfo> SOURCE_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceClusterInfo").getter(ClusterOperationInfo.getter(ClusterOperationInfo::sourceClusterInfo)).setter(ClusterOperationInfo.setter(Builder::sourceClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceClusterInfo").build()}).build();
    private static final SdkField<MutableClusterInfo> TARGET_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetClusterInfo").getter(ClusterOperationInfo.getter(ClusterOperationInfo::targetClusterInfo)).setter(ClusterOperationInfo.setter(Builder::targetClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterInfo").build()}).build();
    private static final SdkField<VpcConnectionInfo> VPC_CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionInfo").getter(ClusterOperationInfo.getter(ClusterOperationInfo::vpcConnectionInfo)).setter(ClusterOperationInfo.setter(Builder::vpcConnectionInfo)).constructor(VpcConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_ID_FIELD, CLUSTER_ARN_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, ERROR_INFO_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD, OPERATION_STEPS_FIELD, OPERATION_TYPE_FIELD, SOURCE_CLUSTER_INFO_FIELD, TARGET_CLUSTER_INFO_FIELD, VPC_CONNECTION_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterOperationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientRequestId;
    private final String clusterArn;
    private final Instant creationTime;
    private final Instant endTime;
    private final ErrorInfo errorInfo;
    private final String operationArn;
    private final String operationState;
    private final List<ClusterOperationStep> operationSteps;
    private final String operationType;
    private final MutableClusterInfo sourceClusterInfo;
    private final MutableClusterInfo targetClusterInfo;
    private final VpcConnectionInfo vpcConnectionInfo;

    private ClusterOperationInfo(BuilderImpl builder) {
        this.clientRequestId = builder.clientRequestId;
        this.clusterArn = builder.clusterArn;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.errorInfo = builder.errorInfo;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationSteps = builder.operationSteps;
        this.operationType = builder.operationType;
        this.sourceClusterInfo = builder.sourceClusterInfo;
        this.targetClusterInfo = builder.targetClusterInfo;
        this.vpcConnectionInfo = builder.vpcConnectionInfo;
    }

    public final String clientRequestId() {
        return this.clientRequestId;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final String operationArn() {
        return this.operationArn;
    }

    public final String operationState() {
        return this.operationState;
    }

    public final boolean hasOperationSteps() {
        return this.operationSteps != null && !(this.operationSteps instanceof SdkAutoConstructList);
    }

    public final List<ClusterOperationStep> operationSteps() {
        return this.operationSteps;
    }

    public final String operationType() {
        return this.operationType;
    }

    public final MutableClusterInfo sourceClusterInfo() {
        return this.sourceClusterInfo;
    }

    public final MutableClusterInfo targetClusterInfo() {
        return this.targetClusterInfo;
    }

    public final VpcConnectionInfo vpcConnectionInfo() {
        return this.vpcConnectionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationSteps() ? this.operationSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationInfo)) {
            return false;
        }
        ClusterOperationInfo other = (ClusterOperationInfo)obj;
        return Objects.equals(this.clientRequestId(), other.clientRequestId()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.operationArn(), other.operationArn()) && Objects.equals(this.operationState(), other.operationState()) && this.hasOperationSteps() == other.hasOperationSteps() && Objects.equals(this.operationSteps(), other.operationSteps()) && Objects.equals(this.operationType(), other.operationType()) && Objects.equals(this.sourceClusterInfo(), other.sourceClusterInfo()) && Objects.equals(this.targetClusterInfo(), other.targetClusterInfo()) && Objects.equals(this.vpcConnectionInfo(), other.vpcConnectionInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterOperationInfo").add("ClientRequestId", (Object)this.clientRequestId()).add("ClusterArn", (Object)this.clusterArn()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("ErrorInfo", (Object)this.errorInfo()).add("OperationArn", (Object)this.operationArn()).add("OperationState", (Object)this.operationState()).add("OperationSteps", this.hasOperationSteps() ? this.operationSteps() : null).add("OperationType", (Object)this.operationType()).add("SourceClusterInfo", (Object)this.sourceClusterInfo()).add("TargetClusterInfo", (Object)this.targetClusterInfo()).add("VpcConnectionInfo", (Object)this.vpcConnectionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestId": {
                return Optional.ofNullable(clazz.cast(this.clientRequestId()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "OperationArn": {
                return Optional.ofNullable(clazz.cast(this.operationArn()));
            }
            case "OperationState": {
                return Optional.ofNullable(clazz.cast(this.operationState()));
            }
            case "OperationSteps": {
                return Optional.ofNullable(clazz.cast(this.operationSteps()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationType()));
            }
            case "SourceClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceClusterInfo()));
            }
            case "TargetClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.targetClusterInfo()));
            }
            case "VpcConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientRequestId", CLIENT_REQUEST_ID_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("operationArn", OPERATION_ARN_FIELD);
        map.put("operationState", OPERATION_STATE_FIELD);
        map.put("operationSteps", OPERATION_STEPS_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("sourceClusterInfo", SOURCE_CLUSTER_INFO_FIELD);
        map.put("targetClusterInfo", TARGET_CLUSTER_INFO_FIELD);
        map.put("vpcConnectionInfo", VPC_CONNECTION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationInfo, T> g) {
        return obj -> g.apply((ClusterOperationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientRequestId;
        private String clusterArn;
        private Instant creationTime;
        private Instant endTime;
        private ErrorInfo errorInfo;
        private String operationArn;
        private String operationState;
        private List<ClusterOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();
        private String operationType;
        private MutableClusterInfo sourceClusterInfo;
        private MutableClusterInfo targetClusterInfo;
        private VpcConnectionInfo vpcConnectionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationInfo model) {
            this.clientRequestId(model.clientRequestId);
            this.clusterArn(model.clusterArn);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.errorInfo(model.errorInfo);
            this.operationArn(model.operationArn);
            this.operationState(model.operationState);
            this.operationSteps(model.operationSteps);
            this.operationType(model.operationType);
            this.sourceClusterInfo(model.sourceClusterInfo);
            this.targetClusterInfo(model.targetClusterInfo);
            this.vpcConnectionInfo(model.vpcConnectionInfo);
        }

        public final String getClientRequestId() {
            return this.clientRequestId;
        }

        public final void setClientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
        }

        @Override
        public final Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final String getOperationArn() {
            return this.operationArn;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final List<ClusterOperationStep.Builder> getOperationSteps() {
            List<ClusterOperationStep.Builder> result = ___listOfClusterOperationStepCopier.copyToBuilder(this.operationSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationSteps(Collection<ClusterOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copyFromBuilder(operationSteps);
        }

        @Override
        public final Builder operationSteps(Collection<ClusterOperationStep> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ClusterOperationStep ... operationSteps) {
            this.operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... operationSteps) {
            this.operationSteps(Stream.of(operationSteps).map(c -> (ClusterOperationStep)((ClusterOperationStep.Builder)ClusterOperationStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public final MutableClusterInfo.Builder getSourceClusterInfo() {
            return this.sourceClusterInfo != null ? this.sourceClusterInfo.toBuilder() : null;
        }

        public final void setSourceClusterInfo(MutableClusterInfo.BuilderImpl sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo != null ? sourceClusterInfo.build() : null;
        }

        @Override
        public final Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo;
            return this;
        }

        public final MutableClusterInfo.Builder getTargetClusterInfo() {
            return this.targetClusterInfo != null ? this.targetClusterInfo.toBuilder() : null;
        }

        public final void setTargetClusterInfo(MutableClusterInfo.BuilderImpl targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo != null ? targetClusterInfo.build() : null;
        }

        @Override
        public final Builder targetClusterInfo(MutableClusterInfo targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo;
            return this;
        }

        public final VpcConnectionInfo.Builder getVpcConnectionInfo() {
            return this.vpcConnectionInfo != null ? this.vpcConnectionInfo.toBuilder() : null;
        }

        public final void setVpcConnectionInfo(VpcConnectionInfo.BuilderImpl vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo != null ? vpcConnectionInfo.build() : null;
        }

        @Override
        public final Builder vpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo;
            return this;
        }

        public ClusterOperationInfo build() {
            return new ClusterOperationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationInfo> {
        public Builder clientRequestId(String var1);

        public Builder clusterArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder operationArn(String var1);

        public Builder operationState(String var1);

        public Builder operationSteps(Collection<ClusterOperationStep> var1);

        public Builder operationSteps(ClusterOperationStep ... var1);

        public Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... var1);

        public Builder operationType(String var1);

        public Builder sourceClusterInfo(MutableClusterInfo var1);

        default public Builder sourceClusterInfo(Consumer<MutableClusterInfo.Builder> sourceClusterInfo) {
            return this.sourceClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(sourceClusterInfo)).build());
        }

        public Builder targetClusterInfo(MutableClusterInfo var1);

        default public Builder targetClusterInfo(Consumer<MutableClusterInfo.Builder> targetClusterInfo) {
            return this.targetClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(targetClusterInfo)).build());
        }

        public Builder vpcConnectionInfo(VpcConnectionInfo var1);

        default public Builder vpcConnectionInfo(Consumer<VpcConnectionInfo.Builder> vpcConnectionInfo) {
            return this.vpcConnectionInfo((VpcConnectionInfo)((VpcConnectionInfo.Builder)VpcConnectionInfo.builder().applyMutation(vpcConnectionInfo)).build());
        }
    }
}

