/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaClusterDescription;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription;
import software.amazon.awssdk.services.kafka.model.ReplicationStateInfo;
import software.amazon.awssdk.services.kafka.model.ReplicatorState;
import software.amazon.awssdk.services.kafka.model.___listOfKafkaClusterDescriptionCopier;
import software.amazon.awssdk.services.kafka.model.___listOfReplicationInfoDescriptionCopier;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicatorResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, DescribeReplicatorResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::creationTime)).setter(DescribeReplicatorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::currentVersion)).setter(DescribeReplicatorResponse.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<Boolean> IS_REPLICATOR_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsReplicatorReference").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::isReplicatorReference)).setter(DescribeReplicatorResponse.setter(Builder::isReplicatorReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isReplicatorReference").build()}).build();
    private static final SdkField<List<KafkaClusterDescription>> KAFKA_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KafkaClusters").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::kafkaClusters)).setter(DescribeReplicatorResponse.setter(Builder::kafkaClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KafkaClusterDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReplicationInfoDescription>> REPLICATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInfoList").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicationInfoList)).setter(DescribeReplicatorResponse.setter(Builder::replicationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationInfoDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorArn").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicatorArn)).setter(DescribeReplicatorResponse.setter(Builder::replicatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()}).build();
    private static final SdkField<String> REPLICATOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorDescription").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicatorDescription)).setter(DescribeReplicatorResponse.setter(Builder::replicatorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorDescription").build()}).build();
    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorName").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicatorName)).setter(DescribeReplicatorResponse.setter(Builder::replicatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()}).build();
    private static final SdkField<String> REPLICATOR_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorResourceArn").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicatorResourceArn)).setter(DescribeReplicatorResponse.setter(Builder::replicatorResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorResourceArn").build()}).build();
    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorState").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::replicatorStateAsString)).setter(DescribeReplicatorResponse.setter(Builder::replicatorState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceExecutionRoleArn").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::serviceExecutionRoleArn)).setter(DescribeReplicatorResponse.setter(Builder::serviceExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build()}).build();
    private static final SdkField<ReplicationStateInfo> STATE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateInfo").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::stateInfo)).setter(DescribeReplicatorResponse.setter(Builder::stateInfo)).constructor(ReplicationStateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeReplicatorResponse.getter(DescribeReplicatorResponse::tags)).setter(DescribeReplicatorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, IS_REPLICATOR_REFERENCE_FIELD, KAFKA_CLUSTERS_FIELD, REPLICATION_INFO_LIST_FIELD, REPLICATOR_ARN_FIELD, REPLICATOR_DESCRIPTION_FIELD, REPLICATOR_NAME_FIELD, REPLICATOR_RESOURCE_ARN_FIELD, REPLICATOR_STATE_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, STATE_INFO_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReplicatorResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final String currentVersion;
    private final Boolean isReplicatorReference;
    private final List<KafkaClusterDescription> kafkaClusters;
    private final List<ReplicationInfoDescription> replicationInfoList;
    private final String replicatorArn;
    private final String replicatorDescription;
    private final String replicatorName;
    private final String replicatorResourceArn;
    private final String replicatorState;
    private final String serviceExecutionRoleArn;
    private final ReplicationStateInfo stateInfo;
    private final Map<String, String> tags;

    private DescribeReplicatorResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.isReplicatorReference = builder.isReplicatorReference;
        this.kafkaClusters = builder.kafkaClusters;
        this.replicationInfoList = builder.replicationInfoList;
        this.replicatorArn = builder.replicatorArn;
        this.replicatorDescription = builder.replicatorDescription;
        this.replicatorName = builder.replicatorName;
        this.replicatorResourceArn = builder.replicatorResourceArn;
        this.replicatorState = builder.replicatorState;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final Boolean isReplicatorReference() {
        return this.isReplicatorReference;
    }

    public final boolean hasKafkaClusters() {
        return this.kafkaClusters != null && !(this.kafkaClusters instanceof SdkAutoConstructList);
    }

    public final List<KafkaClusterDescription> kafkaClusters() {
        return this.kafkaClusters;
    }

    public final boolean hasReplicationInfoList() {
        return this.replicationInfoList != null && !(this.replicationInfoList instanceof SdkAutoConstructList);
    }

    public final List<ReplicationInfoDescription> replicationInfoList() {
        return this.replicationInfoList;
    }

    public final String replicatorArn() {
        return this.replicatorArn;
    }

    public final String replicatorDescription() {
        return this.replicatorDescription;
    }

    public final String replicatorName() {
        return this.replicatorName;
    }

    public final String replicatorResourceArn() {
        return this.replicatorResourceArn;
    }

    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(this.replicatorState);
    }

    public final String replicatorStateAsString() {
        return this.replicatorState;
    }

    public final String serviceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public final ReplicationStateInfo stateInfo() {
        return this.stateInfo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isReplicatorReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKafkaClusters() ? this.kafkaClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInfoList() ? this.replicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicatorResponse)) {
            return false;
        }
        DescribeReplicatorResponse other = (DescribeReplicatorResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.isReplicatorReference(), other.isReplicatorReference()) && this.hasKafkaClusters() == other.hasKafkaClusters() && Objects.equals(this.kafkaClusters(), other.kafkaClusters()) && this.hasReplicationInfoList() == other.hasReplicationInfoList() && Objects.equals(this.replicationInfoList(), other.replicationInfoList()) && Objects.equals(this.replicatorArn(), other.replicatorArn()) && Objects.equals(this.replicatorDescription(), other.replicatorDescription()) && Objects.equals(this.replicatorName(), other.replicatorName()) && Objects.equals(this.replicatorResourceArn(), other.replicatorResourceArn()) && Objects.equals(this.replicatorStateAsString(), other.replicatorStateAsString()) && Objects.equals(this.serviceExecutionRoleArn(), other.serviceExecutionRoleArn()) && Objects.equals(this.stateInfo(), other.stateInfo()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicatorResponse").add("CreationTime", (Object)this.creationTime()).add("CurrentVersion", (Object)this.currentVersion()).add("IsReplicatorReference", (Object)this.isReplicatorReference()).add("KafkaClusters", this.hasKafkaClusters() ? this.kafkaClusters() : null).add("ReplicationInfoList", this.hasReplicationInfoList() ? this.replicationInfoList() : null).add("ReplicatorArn", (Object)this.replicatorArn()).add("ReplicatorDescription", (Object)this.replicatorDescription()).add("ReplicatorName", (Object)this.replicatorName()).add("ReplicatorResourceArn", (Object)this.replicatorResourceArn()).add("ReplicatorState", (Object)this.replicatorStateAsString()).add("ServiceExecutionRoleArn", (Object)this.serviceExecutionRoleArn()).add("StateInfo", (Object)this.stateInfo()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "IsReplicatorReference": {
                return Optional.ofNullable(clazz.cast(this.isReplicatorReference()));
            }
            case "KafkaClusters": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusters()));
            }
            case "ReplicationInfoList": {
                return Optional.ofNullable(clazz.cast(this.replicationInfoList()));
            }
            case "ReplicatorArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorArn()));
            }
            case "ReplicatorDescription": {
                return Optional.ofNullable(clazz.cast(this.replicatorDescription()));
            }
            case "ReplicatorName": {
                return Optional.ofNullable(clazz.cast(this.replicatorName()));
            }
            case "ReplicatorResourceArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorResourceArn()));
            }
            case "ReplicatorState": {
                return Optional.ofNullable(clazz.cast(this.replicatorStateAsString()));
            }
            case "ServiceExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRoleArn()));
            }
            case "StateInfo": {
                return Optional.ofNullable(clazz.cast(this.stateInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("isReplicatorReference", IS_REPLICATOR_REFERENCE_FIELD);
        map.put("kafkaClusters", KAFKA_CLUSTERS_FIELD);
        map.put("replicationInfoList", REPLICATION_INFO_LIST_FIELD);
        map.put("replicatorArn", REPLICATOR_ARN_FIELD);
        map.put("replicatorDescription", REPLICATOR_DESCRIPTION_FIELD);
        map.put("replicatorName", REPLICATOR_NAME_FIELD);
        map.put("replicatorResourceArn", REPLICATOR_RESOURCE_ARN_FIELD);
        map.put("replicatorState", REPLICATOR_STATE_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("stateInfo", STATE_INFO_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicatorResponse, T> g) {
        return obj -> g.apply((DescribeReplicatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String currentVersion;
        private Boolean isReplicatorReference;
        private List<KafkaClusterDescription> kafkaClusters = DefaultSdkAutoConstructList.getInstance();
        private List<ReplicationInfoDescription> replicationInfoList = DefaultSdkAutoConstructList.getInstance();
        private String replicatorArn;
        private String replicatorDescription;
        private String replicatorName;
        private String replicatorResourceArn;
        private String replicatorState;
        private String serviceExecutionRoleArn;
        private ReplicationStateInfo stateInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicatorResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.currentVersion(model.currentVersion);
            this.isReplicatorReference(model.isReplicatorReference);
            this.kafkaClusters(model.kafkaClusters);
            this.replicationInfoList(model.replicationInfoList);
            this.replicatorArn(model.replicatorArn);
            this.replicatorDescription(model.replicatorDescription);
            this.replicatorName(model.replicatorName);
            this.replicatorResourceArn(model.replicatorResourceArn);
            this.replicatorState(model.replicatorState);
            this.serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            this.stateInfo(model.stateInfo);
            this.tags(model.tags);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Boolean getIsReplicatorReference() {
            return this.isReplicatorReference;
        }

        public final void setIsReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
        }

        @Override
        public final Builder isReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
            return this;
        }

        public final List<KafkaClusterDescription.Builder> getKafkaClusters() {
            List<KafkaClusterDescription.Builder> result = ___listOfKafkaClusterDescriptionCopier.copyToBuilder(this.kafkaClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClusters(Collection<KafkaClusterDescription.BuilderImpl> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterDescriptionCopier.copyFromBuilder(kafkaClusters);
        }

        @Override
        public final Builder kafkaClusters(Collection<KafkaClusterDescription> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterDescriptionCopier.copy(kafkaClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(KafkaClusterDescription ... kafkaClusters) {
            this.kafkaClusters(Arrays.asList(kafkaClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(Consumer<KafkaClusterDescription.Builder> ... kafkaClusters) {
            this.kafkaClusters(Stream.of(kafkaClusters).map(c -> (KafkaClusterDescription)((KafkaClusterDescription.Builder)KafkaClusterDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfoDescription.Builder> getReplicationInfoList() {
            List<ReplicationInfoDescription.Builder> result = ___listOfReplicationInfoDescriptionCopier.copyToBuilder(this.replicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoList(Collection<ReplicationInfoDescription.BuilderImpl> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoDescriptionCopier.copyFromBuilder(replicationInfoList);
        }

        @Override
        public final Builder replicationInfoList(Collection<ReplicationInfoDescription> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoDescriptionCopier.copy(replicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(ReplicationInfoDescription ... replicationInfoList) {
            this.replicationInfoList(Arrays.asList(replicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(Consumer<ReplicationInfoDescription.Builder> ... replicationInfoList) {
            this.replicationInfoList(Stream.of(replicationInfoList).map(c -> (ReplicationInfoDescription)((ReplicationInfoDescription.Builder)ReplicationInfoDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorArn() {
            return this.replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorDescription() {
            return this.replicatorDescription;
        }

        public final void setReplicatorDescription(String replicatorDescription) {
            this.replicatorDescription = replicatorDescription;
        }

        @Override
        public final Builder replicatorDescription(String replicatorDescription) {
            this.replicatorDescription = replicatorDescription;
            return this;
        }

        public final String getReplicatorName() {
            return this.replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getReplicatorResourceArn() {
            return this.replicatorResourceArn;
        }

        public final void setReplicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
        }

        @Override
        public final Builder replicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
            return this;
        }

        public final String getReplicatorState() {
            return this.replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final ReplicationStateInfo.Builder getStateInfo() {
            return this.stateInfo != null ? this.stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(ReplicationStateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(ReplicationStateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeReplicatorResponse build() {
            return new DescribeReplicatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicatorResponse> {
        public Builder creationTime(Instant var1);

        public Builder currentVersion(String var1);

        public Builder isReplicatorReference(Boolean var1);

        public Builder kafkaClusters(Collection<KafkaClusterDescription> var1);

        public Builder kafkaClusters(KafkaClusterDescription ... var1);

        public Builder kafkaClusters(Consumer<KafkaClusterDescription.Builder> ... var1);

        public Builder replicationInfoList(Collection<ReplicationInfoDescription> var1);

        public Builder replicationInfoList(ReplicationInfoDescription ... var1);

        public Builder replicationInfoList(Consumer<ReplicationInfoDescription.Builder> ... var1);

        public Builder replicatorArn(String var1);

        public Builder replicatorDescription(String var1);

        public Builder replicatorName(String var1);

        public Builder replicatorResourceArn(String var1);

        public Builder replicatorState(String var1);

        public Builder replicatorState(ReplicatorState var1);

        public Builder serviceExecutionRoleArn(String var1);

        public Builder stateInfo(ReplicationStateInfo var1);

        default public Builder stateInfo(Consumer<ReplicationStateInfo.Builder> stateInfo) {
            return this.stateInfo((ReplicationStateInfo)((ReplicationStateInfo.Builder)ReplicationStateInfo.builder().applyMutation(stateInfo)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

