/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.ReplicatorState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicatorResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, CreateReplicatorResponse> {
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorArn").getter(CreateReplicatorResponse.getter(CreateReplicatorResponse::replicatorArn)).setter(CreateReplicatorResponse.setter(Builder::replicatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()}).build();
    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorName").getter(CreateReplicatorResponse.getter(CreateReplicatorResponse::replicatorName)).setter(CreateReplicatorResponse.setter(Builder::replicatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()}).build();
    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorState").getter(CreateReplicatorResponse.getter(CreateReplicatorResponse::replicatorStateAsString)).setter(CreateReplicatorResponse.setter(Builder::replicatorState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATOR_ARN_FIELD, REPLICATOR_NAME_FIELD, REPLICATOR_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplicatorResponse.memberNameToFieldInitializer();
    private final String replicatorArn;
    private final String replicatorName;
    private final String replicatorState;

    private CreateReplicatorResponse(BuilderImpl builder) {
        super(builder);
        this.replicatorArn = builder.replicatorArn;
        this.replicatorName = builder.replicatorName;
        this.replicatorState = builder.replicatorState;
    }

    public final String replicatorArn() {
        return this.replicatorArn;
    }

    public final String replicatorName() {
        return this.replicatorName;
    }

    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(this.replicatorState);
    }

    public final String replicatorStateAsString() {
        return this.replicatorState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicatorResponse)) {
            return false;
        }
        CreateReplicatorResponse other = (CreateReplicatorResponse)((Object)obj);
        return Objects.equals(this.replicatorArn(), other.replicatorArn()) && Objects.equals(this.replicatorName(), other.replicatorName()) && Objects.equals(this.replicatorStateAsString(), other.replicatorStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicatorResponse").add("ReplicatorArn", (Object)this.replicatorArn()).add("ReplicatorName", (Object)this.replicatorName()).add("ReplicatorState", (Object)this.replicatorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicatorArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorArn()));
            }
            case "ReplicatorName": {
                return Optional.ofNullable(clazz.cast(this.replicatorName()));
            }
            case "ReplicatorState": {
                return Optional.ofNullable(clazz.cast(this.replicatorStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("replicatorArn", REPLICATOR_ARN_FIELD);
        map.put("replicatorName", REPLICATOR_NAME_FIELD);
        map.put("replicatorState", REPLICATOR_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicatorResponse, T> g) {
        return obj -> g.apply((CreateReplicatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String replicatorArn;
        private String replicatorName;
        private String replicatorState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicatorResponse model) {
            super(model);
            this.replicatorArn(model.replicatorArn);
            this.replicatorName(model.replicatorName);
            this.replicatorState(model.replicatorState);
        }

        public final String getReplicatorArn() {
            return this.replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorName() {
            return this.replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getReplicatorState() {
            return this.replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        @Override
        public CreateReplicatorResponse build() {
            return new CreateReplicatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicatorResponse> {
        public Builder replicatorArn(String var1);

        public Builder replicatorName(String var1);

        public Builder replicatorState(String var1);

        public Builder replicatorState(ReplicatorState var1);
    }
}

