/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ClusterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationV2Summary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationV2Summary> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::clusterArn)).setter(ClusterOperationV2Summary.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::clusterTypeAsString)).setter(ClusterOperationV2Summary.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::startTime)).setter(ClusterOperationV2Summary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::endTime)).setter(ClusterOperationV2Summary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationArn").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::operationArn)).setter(ClusterOperationV2Summary.setter(Builder::operationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationState").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::operationState)).setter(ClusterOperationV2Summary.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(ClusterOperationV2Summary.getter(ClusterOperationV2Summary::operationType)).setter(ClusterOperationV2Summary.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD, OPERATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("clusterType", CLUSTER_TYPE_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("operationArn", OPERATION_ARN_FIELD);
            this.put("operationState", OPERATION_STATE_FIELD);
            this.put("operationType", OPERATION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterType;
    private final Instant startTime;
    private final Instant endTime;
    private final String operationArn;
    private final String operationState;
    private final String operationType;

    private ClusterOperationV2Summary(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterType = builder.clusterType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationType = builder.operationType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final ClusterType clusterType() {
        return ClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String operationArn() {
        return this.operationArn;
    }

    public final String operationState() {
        return this.operationState;
    }

    public final String operationType() {
        return this.operationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2Summary)) {
            return false;
        }
        ClusterOperationV2Summary other = (ClusterOperationV2Summary)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.operationArn(), other.operationArn()) && Objects.equals(this.operationState(), other.operationState()) && Objects.equals(this.operationType(), other.operationType());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterOperationV2Summary").add("ClusterArn", (Object)this.clusterArn()).add("ClusterType", (Object)this.clusterTypeAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("OperationArn", (Object)this.operationArn()).add("OperationState", (Object)this.operationState()).add("OperationType", (Object)this.operationType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "OperationArn": {
                return Optional.ofNullable(clazz.cast(this.operationArn()));
            }
            case "OperationState": {
                return Optional.ofNullable(clazz.cast(this.operationState()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationV2Summary, T> g) {
        return obj -> g.apply((ClusterOperationV2Summary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterType;
        private Instant startTime;
        private Instant endTime;
        private String operationArn;
        private String operationState;
        private String operationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationV2Summary model) {
            this.clusterArn(model.clusterArn);
            this.clusterType(model.clusterType);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.operationArn(model.operationArn);
            this.operationState(model.operationState);
            this.operationType(model.operationType);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationArn() {
            return this.operationArn;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public ClusterOperationV2Summary build() {
            return new ClusterOperationV2Summary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationV2Summary> {
        public Builder clusterArn(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(ClusterType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder operationArn(String var1);

        public Builder operationState(String var1);

        public Builder operationType(String var1);
    }
}

