/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.PublicAccess;
import software.amazon.awssdk.services.kafka.model.VpcConnectivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectivityInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectivityInfo> {
    private static final SdkField<PublicAccess> PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccess").getter(ConnectivityInfo.getter(ConnectivityInfo::publicAccess)).setter(ConnectivityInfo.setter(Builder::publicAccess)).constructor(PublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()}).build();
    private static final SdkField<VpcConnectivity> VPC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectivity").getter(ConnectivityInfo.getter(ConnectivityInfo::vpcConnectivity)).setter(ConnectivityInfo.setter(Builder::vpcConnectivity)).constructor(VpcConnectivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_ACCESS_FIELD, VPC_CONNECTIVITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("publicAccess", PUBLIC_ACCESS_FIELD);
            this.put("vpcConnectivity", VPC_CONNECTIVITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PublicAccess publicAccess;
    private final VpcConnectivity vpcConnectivity;

    private ConnectivityInfo(BuilderImpl builder) {
        this.publicAccess = builder.publicAccess;
        this.vpcConnectivity = builder.vpcConnectivity;
    }

    public final PublicAccess publicAccess() {
        return this.publicAccess;
    }

    public final VpcConnectivity vpcConnectivity() {
        return this.vpcConnectivity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectivity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo)obj;
        return Objects.equals(this.publicAccess(), other.publicAccess()) && Objects.equals(this.vpcConnectivity(), other.vpcConnectivity());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectivityInfo").add("PublicAccess", (Object)this.publicAccess()).add("VpcConnectivity", (Object)this.vpcConnectivity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAccess()));
            }
            case "VpcConnectivity": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectivity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityInfo, T> g) {
        return obj -> g.apply((ConnectivityInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PublicAccess publicAccess;
        private VpcConnectivity vpcConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            this.publicAccess(model.publicAccess);
            this.vpcConnectivity(model.vpcConnectivity);
        }

        public final PublicAccess.Builder getPublicAccess() {
            return this.publicAccess != null ? this.publicAccess.toBuilder() : null;
        }

        public final void setPublicAccess(PublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        @Override
        public final Builder publicAccess(PublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final VpcConnectivity.Builder getVpcConnectivity() {
            return this.vpcConnectivity != null ? this.vpcConnectivity.toBuilder() : null;
        }

        public final void setVpcConnectivity(VpcConnectivity.BuilderImpl vpcConnectivity) {
            this.vpcConnectivity = vpcConnectivity != null ? vpcConnectivity.build() : null;
        }

        @Override
        public final Builder vpcConnectivity(VpcConnectivity vpcConnectivity) {
            this.vpcConnectivity = vpcConnectivity;
            return this;
        }

        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectivityInfo> {
        public Builder publicAccess(PublicAccess var1);

        default public Builder publicAccess(Consumer<PublicAccess.Builder> publicAccess) {
            return this.publicAccess((PublicAccess)((PublicAccess.Builder)PublicAccess.builder().applyMutation(publicAccess)).build());
        }

        public Builder vpcConnectivity(VpcConnectivity var1);

        default public Builder vpcConnectivity(Consumer<VpcConnectivity.Builder> vpcConnectivity) {
            return this.vpcConnectivity((VpcConnectivity)((VpcConnectivity.Builder)VpcConnectivity.builder().applyMutation(vpcConnectivity)).build());
        }
    }
}

