/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__doubleCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerCountUpdateInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerCountUpdateInfo> {
    private static final SdkField<List<Double>> CREATED_BROKER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreatedBrokerIds").getter(BrokerCountUpdateInfo.getter(BrokerCountUpdateInfo::createdBrokerIds)).setter(BrokerCountUpdateInfo.setter(Builder::createdBrokerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBrokerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DELETED_BROKER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeletedBrokerIds").getter(BrokerCountUpdateInfo.getter(BrokerCountUpdateInfo::deletedBrokerIds)).setter(BrokerCountUpdateInfo.setter(Builder::deletedBrokerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedBrokerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BROKER_IDS_FIELD, DELETED_BROKER_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Double> createdBrokerIds;
    private final List<Double> deletedBrokerIds;

    private BrokerCountUpdateInfo(BuilderImpl builder) {
        this.createdBrokerIds = builder.createdBrokerIds;
        this.deletedBrokerIds = builder.deletedBrokerIds;
    }

    public final boolean hasCreatedBrokerIds() {
        return this.createdBrokerIds != null && !(this.createdBrokerIds instanceof SdkAutoConstructList);
    }

    public final List<Double> createdBrokerIds() {
        return this.createdBrokerIds;
    }

    public final boolean hasDeletedBrokerIds() {
        return this.deletedBrokerIds != null && !(this.deletedBrokerIds instanceof SdkAutoConstructList);
    }

    public final List<Double> deletedBrokerIds() {
        return this.deletedBrokerIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatedBrokerIds() ? this.createdBrokerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletedBrokerIds() ? this.deletedBrokerIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerCountUpdateInfo)) {
            return false;
        }
        BrokerCountUpdateInfo other = (BrokerCountUpdateInfo)obj;
        return this.hasCreatedBrokerIds() == other.hasCreatedBrokerIds() && Objects.equals(this.createdBrokerIds(), other.createdBrokerIds()) && this.hasDeletedBrokerIds() == other.hasDeletedBrokerIds() && Objects.equals(this.deletedBrokerIds(), other.deletedBrokerIds());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerCountUpdateInfo").add("CreatedBrokerIds", this.hasCreatedBrokerIds() ? this.createdBrokerIds() : null).add("DeletedBrokerIds", this.hasDeletedBrokerIds() ? this.deletedBrokerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBrokerIds": {
                return Optional.ofNullable(clazz.cast(this.createdBrokerIds()));
            }
            case "DeletedBrokerIds": {
                return Optional.ofNullable(clazz.cast(this.deletedBrokerIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerCountUpdateInfo, T> g) {
        return obj -> g.apply((BrokerCountUpdateInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> createdBrokerIds = DefaultSdkAutoConstructList.getInstance();
        private List<Double> deletedBrokerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerCountUpdateInfo model) {
            this.createdBrokerIds(model.createdBrokerIds);
            this.deletedBrokerIds(model.deletedBrokerIds);
        }

        public final Collection<Double> getCreatedBrokerIds() {
            if (this.createdBrokerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createdBrokerIds;
        }

        public final void setCreatedBrokerIds(Collection<Double> createdBrokerIds) {
            this.createdBrokerIds = ___listOf__doubleCopier.copy(createdBrokerIds);
        }

        @Override
        public final Builder createdBrokerIds(Collection<Double> createdBrokerIds) {
            this.createdBrokerIds = ___listOf__doubleCopier.copy(createdBrokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdBrokerIds(Double ... createdBrokerIds) {
            this.createdBrokerIds(Arrays.asList(createdBrokerIds));
            return this;
        }

        public final Collection<Double> getDeletedBrokerIds() {
            if (this.deletedBrokerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletedBrokerIds;
        }

        public final void setDeletedBrokerIds(Collection<Double> deletedBrokerIds) {
            this.deletedBrokerIds = ___listOf__doubleCopier.copy(deletedBrokerIds);
        }

        @Override
        public final Builder deletedBrokerIds(Collection<Double> deletedBrokerIds) {
            this.deletedBrokerIds = ___listOf__doubleCopier.copy(deletedBrokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedBrokerIds(Double ... deletedBrokerIds) {
            this.deletedBrokerIds(Arrays.asList(deletedBrokerIds));
            return this;
        }

        public BrokerCountUpdateInfo build() {
            return new BrokerCountUpdateInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerCountUpdateInfo> {
        public Builder createdBrokerIds(Collection<Double> var1);

        public Builder createdBrokerIds(Double ... var1);

        public Builder deletedBrokerIds(Collection<Double> var1);

        public Builder deletedBrokerIds(Double ... var1);
    }
}

