/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication;
import software.amazon.awssdk.services.kafka.model.TargetCompressionType;
import software.amazon.awssdk.services.kafka.model.TopicReplication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationInfoDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationInfoDescription> {
    private static final SdkField<ConsumerGroupReplication> CONSUMER_GROUP_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication").getter(ReplicationInfoDescription.getter(ReplicationInfoDescription::consumerGroupReplication)).setter(ReplicationInfoDescription.setter(Builder::consumerGroupReplication)).constructor(ConsumerGroupReplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build()}).build();
    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKafkaClusterAlias").getter(ReplicationInfoDescription.getter(ReplicationInfoDescription::sourceKafkaClusterAlias)).setter(ReplicationInfoDescription.setter(Builder::sourceKafkaClusterAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterAlias").build()}).build();
    private static final SdkField<String> TARGET_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCompressionType").getter(ReplicationInfoDescription.getter(ReplicationInfoDescription::targetCompressionTypeAsString)).setter(ReplicationInfoDescription.setter(Builder::targetCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCompressionType").build()}).build();
    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKafkaClusterAlias").getter(ReplicationInfoDescription.getter(ReplicationInfoDescription::targetKafkaClusterAlias)).setter(ReplicationInfoDescription.setter(Builder::targetKafkaClusterAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterAlias").build()}).build();
    private static final SdkField<TopicReplication> TOPIC_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopicReplication").getter(ReplicationInfoDescription.getter(ReplicationInfoDescription::topicReplication)).setter(ReplicationInfoDescription.setter(Builder::topicReplication)).constructor(TopicReplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUP_REPLICATION_FIELD, SOURCE_KAFKA_CLUSTER_ALIAS_FIELD, TARGET_COMPRESSION_TYPE_FIELD, TARGET_KAFKA_CLUSTER_ALIAS_FIELD, TOPIC_REPLICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConsumerGroupReplication consumerGroupReplication;
    private final String sourceKafkaClusterAlias;
    private final String targetCompressionType;
    private final String targetKafkaClusterAlias;
    private final TopicReplication topicReplication;

    private ReplicationInfoDescription(BuilderImpl builder) {
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.sourceKafkaClusterAlias = builder.sourceKafkaClusterAlias;
        this.targetCompressionType = builder.targetCompressionType;
        this.targetKafkaClusterAlias = builder.targetKafkaClusterAlias;
        this.topicReplication = builder.topicReplication;
    }

    public final ConsumerGroupReplication consumerGroupReplication() {
        return this.consumerGroupReplication;
    }

    public final String sourceKafkaClusterAlias() {
        return this.sourceKafkaClusterAlias;
    }

    public final TargetCompressionType targetCompressionType() {
        return TargetCompressionType.fromValue(this.targetCompressionType);
    }

    public final String targetCompressionTypeAsString() {
        return this.targetCompressionType;
    }

    public final String targetKafkaClusterAlias() {
        return this.targetKafkaClusterAlias;
    }

    public final TopicReplication topicReplication() {
        return this.topicReplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicReplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInfoDescription)) {
            return false;
        }
        ReplicationInfoDescription other = (ReplicationInfoDescription)obj;
        return Objects.equals(this.consumerGroupReplication(), other.consumerGroupReplication()) && Objects.equals(this.sourceKafkaClusterAlias(), other.sourceKafkaClusterAlias()) && Objects.equals(this.targetCompressionTypeAsString(), other.targetCompressionTypeAsString()) && Objects.equals(this.targetKafkaClusterAlias(), other.targetKafkaClusterAlias()) && Objects.equals(this.topicReplication(), other.topicReplication());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationInfoDescription").add("ConsumerGroupReplication", (Object)this.consumerGroupReplication()).add("SourceKafkaClusterAlias", (Object)this.sourceKafkaClusterAlias()).add("TargetCompressionType", (Object)this.targetCompressionTypeAsString()).add("TargetKafkaClusterAlias", (Object)this.targetKafkaClusterAlias()).add("TopicReplication", (Object)this.topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerGroupReplication": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupReplication()));
            }
            case "SourceKafkaClusterAlias": {
                return Optional.ofNullable(clazz.cast(this.sourceKafkaClusterAlias()));
            }
            case "TargetCompressionType": {
                return Optional.ofNullable(clazz.cast(this.targetCompressionTypeAsString()));
            }
            case "TargetKafkaClusterAlias": {
                return Optional.ofNullable(clazz.cast(this.targetKafkaClusterAlias()));
            }
            case "TopicReplication": {
                return Optional.ofNullable(clazz.cast(this.topicReplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInfoDescription, T> g) {
        return obj -> g.apply((ReplicationInfoDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConsumerGroupReplication consumerGroupReplication;
        private String sourceKafkaClusterAlias;
        private String targetCompressionType;
        private String targetKafkaClusterAlias;
        private TopicReplication topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInfoDescription model) {
            this.consumerGroupReplication(model.consumerGroupReplication);
            this.sourceKafkaClusterAlias(model.sourceKafkaClusterAlias);
            this.targetCompressionType(model.targetCompressionType);
            this.targetKafkaClusterAlias(model.targetKafkaClusterAlias);
            this.topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplication.Builder getConsumerGroupReplication() {
            return this.consumerGroupReplication != null ? this.consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplication.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getSourceKafkaClusterAlias() {
            return this.sourceKafkaClusterAlias;
        }

        public final void setSourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
        }

        @Override
        public final Builder sourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
            return this;
        }

        public final String getTargetCompressionType() {
            return this.targetCompressionType;
        }

        public final void setTargetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
        }

        @Override
        public final Builder targetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
            return this;
        }

        @Override
        public final Builder targetCompressionType(TargetCompressionType targetCompressionType) {
            this.targetCompressionType(targetCompressionType == null ? null : targetCompressionType.toString());
            return this;
        }

        public final String getTargetKafkaClusterAlias() {
            return this.targetKafkaClusterAlias;
        }

        public final void setTargetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
        }

        @Override
        public final Builder targetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
            return this;
        }

        public final TopicReplication.Builder getTopicReplication() {
            return this.topicReplication != null ? this.topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplication.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplication topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        public ReplicationInfoDescription build() {
            return new ReplicationInfoDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationInfoDescription> {
        public Builder consumerGroupReplication(ConsumerGroupReplication var1);

        default public Builder consumerGroupReplication(Consumer<ConsumerGroupReplication.Builder> consumerGroupReplication) {
            return this.consumerGroupReplication((ConsumerGroupReplication)((ConsumerGroupReplication.Builder)ConsumerGroupReplication.builder().applyMutation(consumerGroupReplication)).build());
        }

        public Builder sourceKafkaClusterAlias(String var1);

        public Builder targetCompressionType(String var1);

        public Builder targetCompressionType(TargetCompressionType var1);

        public Builder targetKafkaClusterAlias(String var1);

        public Builder topicReplication(TopicReplication var1);

        default public Builder topicReplication(Consumer<TopicReplication.Builder> topicReplication) {
            return this.topicReplication((TopicReplication)((TopicReplication.Builder)TopicReplication.builder().applyMutation(topicReplication)).build());
        }
    }
}

