/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetCompressionType {
    NONE("NONE"),
    GZIP("GZIP"),
    SNAPPY("SNAPPY"),
    LZ4("LZ4"),
    ZSTD("ZSTD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetCompressionType> VALUE_MAP;
    private final String value;

    private TargetCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetCompressionType> knownValues() {
        EnumSet<TargetCompressionType> knownValues = EnumSet.allOf(TargetCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetCompressionType.class, TargetCompressionType::toString);
    }
}

