/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ConfigurationRevision;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse;

public class ListConfigurationRevisionsIterable
implements SdkIterable<ListConfigurationRevisionsResponse> {
    private final KafkaClient client;
    private final ListConfigurationRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationRevisionsIterable(KafkaClient client, ListConfigurationRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationRevisionsResponseFetcher();
    }

    public Iterator<ListConfigurationRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationRevision> revisions() {
        Function<ListConfigurationRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationRevisionsResponseFetcher
    implements SyncPageFetcher<ListConfigurationRevisionsResponse> {
        private ListConfigurationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationRevisionsResponse nextPage(ListConfigurationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationRevisionsIterable.this.client.listConfigurationRevisions(ListConfigurationRevisionsIterable.this.firstRequest);
            }
            return ListConfigurationRevisionsIterable.this.client.listConfigurationRevisions((ListConfigurationRevisionsRequest)((Object)ListConfigurationRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

