/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.Configuration;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOfConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationsResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListConfigurationsResponse> {
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configurations").getter(ListConfigurationsResponse.getter(ListConfigurationsResponse::configurations)).setter(ListConfigurationsResponse.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationsResponse.getter(ListConfigurationsResponse::nextToken)).setter(ListConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Configuration> configurations;
    private final String nextToken;

    private ListConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<Configuration> configurations() {
        return this.configurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsResponse)) {
            return false;
        }
        ListConfigurationsResponse other = (ListConfigurationsResponse)((Object)obj);
        return this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationsResponse").add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsResponse model) {
            super(model);
            this.configurations(model.configurations);
            this.nextToken(model.nextToken);
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ___listOfConfigurationCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ___listOfConfigurationCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ___listOfConfigurationCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationsResponse build() {
            return new ListConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationsResponse> {
        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

