/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.ClientVpcConnection;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse;

public class ListClientVpcConnectionsIterable
implements SdkIterable<ListClientVpcConnectionsResponse> {
    private final KafkaClient client;
    private final ListClientVpcConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClientVpcConnectionsIterable(KafkaClient client, ListClientVpcConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClientVpcConnectionsResponseFetcher();
    }

    public Iterator<ListClientVpcConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientVpcConnection> clientVpcConnections() {
        Function<ListClientVpcConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientVpcConnections() != null) {
                return response.clientVpcConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClientVpcConnectionsResponseFetcher
    implements SyncPageFetcher<ListClientVpcConnectionsResponse> {
        private ListClientVpcConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListClientVpcConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClientVpcConnectionsResponse nextPage(ListClientVpcConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListClientVpcConnectionsIterable.this.client.listClientVpcConnections(ListClientVpcConnectionsIterable.this.firstRequest);
            }
            return ListClientVpcConnectionsIterable.this.client.listClientVpcConnections((ListClientVpcConnectionsRequest)((Object)ListClientVpcConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

