/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kafka.DefaultKafkaBaseClientBuilder;
import software.amazon.awssdk.services.kafka.DefaultKafkaClient;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.KafkaClientBuilder;
import software.amazon.awssdk.services.kafka.KafkaServiceClientConfiguration;
import software.amazon.awssdk.services.kafka.endpoints.KafkaEndpointProvider;

@SdkInternalApi
final class DefaultKafkaClientBuilder
extends DefaultKafkaBaseClientBuilder<KafkaClientBuilder, KafkaClient>
implements KafkaClientBuilder {
    DefaultKafkaClientBuilder() {
    }

    @Override
    public DefaultKafkaClientBuilder endpointProvider(KafkaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KafkaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKafkaClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KafkaServiceClientConfiguration serviceClientConfiguration = KafkaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKafkaClient(serviceClientConfiguration, clientConfiguration);
    }
}

