/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateClusterRequest.getter(CreateClusterRequest::brokerNodeGroupInfo)).setter(CreateClusterRequest.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateClusterRequest.getter(CreateClusterRequest::encryptionInfo)).setter(CreateClusterRequest.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClusterRequest.getter(CreateClusterRequest::enhancedMonitoringAsString)).setter(CreateClusterRequest.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClusterRequest.getter(CreateClusterRequest::kafkaVersion)).setter(CreateClusterRequest.setter(Builder::kafkaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateClusterRequest.getter(CreateClusterRequest::numberOfBrokerNodes)).setter(CreateClusterRequest.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD, CLUSTER_NAME_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, KAFKA_VERSION_FIELD, NUMBER_OF_BROKER_NODES_FIELD));
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final String clusterName;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final String kafkaVersion;
    private final Integer numberOfBrokerNodes;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clusterName = builder.clusterName;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.kafkaVersion = builder.kafkaVersion;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
    }

    public BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public String kafkaVersion() {
        return this.kafkaVersion;
    }

    public Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.kafkaVersion(), other.kafkaVersion()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes());
    }

    public String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("ClusterName", (Object)this.clusterName()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("KafkaVersion", (Object)this.kafkaVersion()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "KafkaVersion": {
                return Optional.ofNullable(clazz.cast(this.kafkaVersion()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private String clusterName;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private String kafkaVersion;
        private Integer numberOfBrokerNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.clusterName(model.clusterName);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.kafkaVersion(model.kafkaVersion);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final String getKafkaVersion() {
            return this.kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder clusterName(String var1);

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder kafkaVersion(String var1);

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

