/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.ConfigurationInfo;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo").getter(CreateClusterRequest.getter(CreateClusterRequest::brokerNodeGroupInfo)).setter(CreateClusterRequest.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(CreateClusterRequest.getter(CreateClusterRequest::clientAuthentication)).setter(CreateClusterRequest.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationInfo").getter(CreateClusterRequest.getter(CreateClusterRequest::configurationInfo)).setter(CreateClusterRequest.setter(Builder::configurationInfo)).constructor(ConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(CreateClusterRequest.getter(CreateClusterRequest::encryptionInfo)).setter(CreateClusterRequest.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(CreateClusterRequest.getter(CreateClusterRequest::enhancedMonitoringAsString)).setter(CreateClusterRequest.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(CreateClusterRequest.getter(CreateClusterRequest::openMonitoring)).setter(CreateClusterRequest.setter(Builder::openMonitoring)).constructor(OpenMonitoringInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KafkaVersion").getter(CreateClusterRequest.getter(CreateClusterRequest::kafkaVersion)).setter(CreateClusterRequest.setter(Builder::kafkaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(CreateClusterRequest.getter(CreateClusterRequest::loggingInfo)).setter(CreateClusterRequest.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBrokerNodes").getter(CreateClusterRequest.getter(CreateClusterRequest::numberOfBrokerNodes)).setter(CreateClusterRequest.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_NAME_FIELD, CONFIGURATION_INFO_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, KAFKA_VERSION_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, TAGS_FIELD));
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final ClientAuthentication clientAuthentication;
    private final String clusterName;
    private final ConfigurationInfo configurationInfo;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final OpenMonitoringInfo openMonitoring;
    private final String kafkaVersion;
    private final LoggingInfo loggingInfo;
    private final Integer numberOfBrokerNodes;
    private final Map<String, String> tags;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterName = builder.clusterName;
        this.configurationInfo = builder.configurationInfo;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.kafkaVersion = builder.kafkaVersion;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.tags = builder.tags;
    }

    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final ConfigurationInfo configurationInfo() {
        return this.configurationInfo;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoringInfo openMonitoring() {
        return this.openMonitoring;
    }

    public final String kafkaVersion() {
        return this.kafkaVersion;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.configurationInfo(), other.configurationInfo()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.kafkaVersion(), other.kafkaVersion()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("ClientAuthentication", (Object)this.clientAuthentication()).add("ClusterName", (Object)this.clusterName()).add("ConfigurationInfo", (Object)this.configurationInfo()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("KafkaVersion", (Object)this.kafkaVersion()).add("LoggingInfo", (Object)this.loggingInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "ConfigurationInfo": {
                return Optional.ofNullable(clazz.cast(this.configurationInfo()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "KafkaVersion": {
                return Optional.ofNullable(clazz.cast(this.kafkaVersion()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private ClientAuthentication clientAuthentication;
        private String clusterName;
        private ConfigurationInfo configurationInfo;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private OpenMonitoringInfo openMonitoring;
        private String kafkaVersion;
        private LoggingInfo loggingInfo;
        private Integer numberOfBrokerNodes;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.clientAuthentication(model.clientAuthentication);
            this.clusterName(model.clusterName);
            this.configurationInfo(model.configurationInfo);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.kafkaVersion(model.kafkaVersion);
            this.loggingInfo(model.loggingInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.tags(model.tags);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return this.configurationInfo != null ? this.configurationInfo.toBuilder() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final String getKafkaVersion() {
            return this.kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder clusterName(String var1);

        public Builder configurationInfo(ConfigurationInfo var1);

        default public Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return this.configurationInfo((ConfigurationInfo)((ConfigurationInfo.Builder)ConfigurationInfo.builder().applyMutation(configurationInfo)).build());
        }

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoringInfo var1);

        default public Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoringInfo)((OpenMonitoringInfo.Builder)OpenMonitoringInfo.builder().applyMutation(openMonitoring)).build());
        }

        public Builder kafkaVersion(String var1);

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

