/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootBrokerRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, RebootBrokerRequest> {
    private static final SdkField<List<String>> BROKER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BrokerIds").getter(RebootBrokerRequest.getter(RebootBrokerRequest::brokerIds)).setter(RebootBrokerRequest.setter(Builder::brokerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(RebootBrokerRequest.getter(RebootBrokerRequest::clusterArn)).setter(RebootBrokerRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_IDS_FIELD, CLUSTER_ARN_FIELD));
    private final List<String> brokerIds;
    private final String clusterArn;

    private RebootBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.brokerIds = builder.brokerIds;
        this.clusterArn = builder.clusterArn;
    }

    public final boolean hasBrokerIds() {
        return this.brokerIds != null && !(this.brokerIds instanceof SdkAutoConstructList);
    }

    public final List<String> brokerIds() {
        return this.brokerIds;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrokerIds() ? this.brokerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootBrokerRequest)) {
            return false;
        }
        RebootBrokerRequest other = (RebootBrokerRequest)((Object)obj);
        return this.hasBrokerIds() == other.hasBrokerIds() && Objects.equals(this.brokerIds(), other.brokerIds()) && Objects.equals(this.clusterArn(), other.clusterArn());
    }

    public final String toString() {
        return ToString.builder((String)"RebootBrokerRequest").add("BrokerIds", this.hasBrokerIds() ? this.brokerIds() : null).add("ClusterArn", (Object)this.clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerIds": {
                return Optional.ofNullable(clazz.cast(this.brokerIds()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootBrokerRequest, T> g) {
        return obj -> g.apply((RebootBrokerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private List<String> brokerIds = DefaultSdkAutoConstructList.getInstance();
        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootBrokerRequest model) {
            super(model);
            this.brokerIds(model.brokerIds);
            this.clusterArn(model.clusterArn);
        }

        public final Collection<String> getBrokerIds() {
            if (this.brokerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.brokerIds;
        }

        @Override
        public final Builder brokerIds(Collection<String> brokerIds) {
            this.brokerIds = ___listOf__stringCopier.copy(brokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerIds(String ... brokerIds) {
            this.brokerIds(Arrays.asList(brokerIds));
            return this;
        }

        public final void setBrokerIds(Collection<String> brokerIds) {
            this.brokerIds = ___listOf__stringCopier.copy(brokerIds);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootBrokerRequest build() {
            return new RebootBrokerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebootBrokerRequest> {
        public Builder brokerIds(Collection<String> var1);

        public Builder brokerIds(String ... var1);

        public Builder clusterArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

