/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScramSecretsResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListScramSecretsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScramSecretsResponse.getter(ListScramSecretsResponse::nextToken)).setter(ListScramSecretsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> SECRET_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecretArnList").getter(ListScramSecretsResponse.getter(ListScramSecretsResponse::secretArnList)).setter(ListScramSecretsResponse.setter(Builder::secretArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SECRET_ARN_LIST_FIELD));
    private final String nextToken;
    private final List<String> secretArnList;

    private ListScramSecretsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.secretArnList = builder.secretArnList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSecretArnList() {
        return this.secretArnList != null && !(this.secretArnList instanceof SdkAutoConstructList);
    }

    public List<String> secretArnList() {
        return this.secretArnList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecretArnList() ? this.secretArnList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScramSecretsResponse)) {
            return false;
        }
        ListScramSecretsResponse other = (ListScramSecretsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSecretArnList() == other.hasSecretArnList() && Objects.equals(this.secretArnList(), other.secretArnList());
    }

    public String toString() {
        return ToString.builder((String)"ListScramSecretsResponse").add("NextToken", (Object)this.nextToken()).add("SecretArnList", this.hasSecretArnList() ? this.secretArnList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SecretArnList": {
                return Optional.ofNullable(clazz.cast(this.secretArnList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScramSecretsResponse, T> g) {
        return obj -> g.apply((ListScramSecretsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> secretArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScramSecretsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.secretArnList(model.secretArnList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getSecretArnList() {
            if (this.secretArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.secretArnList;
        }

        @Override
        public final Builder secretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretArnList(String ... secretArnList) {
            this.secretArnList(Arrays.asList(secretArnList));
            return this;
        }

        public final void setSecretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
        }

        @Override
        public ListScramSecretsResponse build() {
            return new ListScramSecretsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScramSecretsResponse> {
        public Builder nextToken(String var1);

        public Builder secretArnList(Collection<String> var1);

        public Builder secretArnList(String ... var1);
    }
}

