/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.KafkaVersion;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse;

public class ListKafkaVersionsIterable
implements SdkIterable<ListKafkaVersionsResponse> {
    private final KafkaClient client;
    private final ListKafkaVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKafkaVersionsIterable(KafkaClient client, ListKafkaVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKafkaVersionsResponseFetcher();
    }

    public Iterator<ListKafkaVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KafkaVersion> kafkaVersions() {
        Function<ListKafkaVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.kafkaVersions() != null) {
                return response.kafkaVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKafkaVersionsResponseFetcher
    implements SyncPageFetcher<ListKafkaVersionsResponse> {
        private ListKafkaVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListKafkaVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKafkaVersionsResponse nextPage(ListKafkaVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListKafkaVersionsIterable.this.client.listKafkaVersions(ListKafkaVersionsIterable.this.firstRequest);
            }
            return ListKafkaVersionsIterable.this.client.listKafkaVersions((ListKafkaVersionsRequest)((Object)ListKafkaVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

